/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DefaultPropertyValueFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UnsupportedPropertyFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

public class DDLPanel
extends DefaultTraversablePanel
implements ActionListener {
    @Deprecated
    public static final String DDL_GENERATOR = "DDlGenerator";
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIBundle.get("SQL_URLFILTER_TEXT"), ".sql");
    private JButton m_btnSave;
    private final BasicEditorPane m_txtSQL = new BasicEditorPane();
    private boolean m_showRadio;
    private ButtonGroup m_btnGrp;
    private JRadioButton m_rdbCreate;
    private JRadioButton m_rdbUpdate;
    private DBEditorConfig m_config;
    private SystemObject m_originalObjectForDDL;
    private final DBObjectListener m_list = new SwingDBObjectListener(){

        @Override
        public void updateUI(DBObjectChange dBObjectChange) {
            DDLPanel.this.updateSQL();
        }
    };

    public DDLPanel() {
        this(true);
    }

    public DDLPanel(boolean bl) {
        this.m_showRadio = bl;
        this.setHelpID("f1_odbddl_html");
    }

    protected final DBEditorConfig getEditorConfig() {
        return this.m_config;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_config = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
        this.layoutComponents();
        if (this.m_rdbUpdate != null) {
            this.m_originalObjectForDDL = this.getOriginalObjectForDDL();
            if (this.m_originalObjectForDDL == null) {
                this.m_rdbUpdate.setEnabled(false);
                this.m_rdbCreate.setSelected(true);
            } else {
                this.m_rdbUpdate.setEnabled(true);
                if (this.defaultToAlterWhenEditing()) {
                    this.m_rdbUpdate.setSelected(true);
                } else {
                    this.m_rdbCreate.setSelected(true);
                }
            }
        }
        if (this.m_config != null) {
            SystemObject systemObject = this.m_config.getUpdatedObject();
            systemObject.addObjectListener(this.m_list);
        }
        this.updateSQL();
    }

    private void updateSQL() {
        String string;
        boolean bl = false;
        try {
            string = this.getSQL();
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            bl = true;
            string = unsupportedDDLException.getMessage();
        }
        catch (Exception exception) {
            string = UIBundle.get("DDL_ERROR");
            DBLog.logStackTrace((String)string, (Throwable)exception);
            bl = true;
        }
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        if (string != null) {
            textBuffer.insert(0, string.toCharArray());
        }
        BasicDocument basicDocument = new BasicDocument(textBuffer);
        basicDocument.setLanguageSupport(bl ? "foo.txt" : "foo.sql");
        this.m_txtSQL.setDocument((Document)basicDocument);
        this.m_btnSave.setEnabled(ModelUtil.hasLength((String)string) && !bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_config != null) {
            SystemObject systemObject = this.m_config.getUpdatedObject();
            systemObject.removeObjectListener(this.m_list);
        }
    }

    protected SystemObject getOriginalObjectForDDL() {
        SystemObject systemObject = this.getEditorConfig().getOriginalObject();
        if (systemObject != null && systemObject.getID() == null) {
            systemObject = null;
        }
        return systemObject;
    }

    protected boolean defaultToAlterWhenEditing() {
        return true;
    }

    protected boolean useProviderTransactionForDiff() {
        return this.m_config != null && this.m_config.isCommitToProvider();
    }

    protected String getSQL() throws UnsupportedDDLException {
        DBObjectTransaction dBObjectTransaction;
        SystemObject systemObject;
        DBObjectProvider dBObjectProvider = this.m_config.getProvider();
        SystemObject systemObject2 = this.m_config.getUpdatedObject();
        boolean bl = this.m_config.isReplaceAllowed();
        DDLOptions dDLOptions = new DDLOptions(bl, false);
        DDLGenerator dDLGenerator = DDLPanel.getDDLGenerator(this.m_config);
        if (dDLGenerator == null) {
            DBLog.getLogger((Object)this).warning("No DDL generator found. DDL panel will not function.");
            return null;
        }
        Object object = systemObject = this.m_rdbCreate != null && this.m_rdbCreate.isSelected() ? null : this.m_originalObjectForDDL;
        if (systemObject == null) {
            dDLOptions.setReplace(false);
        }
        Difference difference = null;
        if (this.useProviderTransactionForDiff()) {
            dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
            dBObjectTransaction.includeUpdate(systemObject, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject2));
            dBObjectTransaction.setReplace(true);
            dBObjectTransaction.setCascade(true);
            try {
                Difference difference2 = dBObjectTransaction.getTransactionDifference();
                difference = difference2.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (difference == null) {
            difference = dBObjectProvider.getDiffEngine().difference((Object)systemObject, (Object)systemObject2);
            difference = difference.getFilteredDifference(new DifferenceFilter[]{new UnsupportedPropertyFilter(dBObjectProvider, dDLGenerator), new DefaultPropertyValueFilter(dBObjectProvider.getPropertyManager(), (PropertyManager)dDLGenerator)});
        }
        dBObjectTransaction = dDLGenerator.getUpdateDDL(dDLOptions, difference);
        return dBObjectTransaction.toString();
    }

    private void layoutComponents() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DDLPanel");
            boolean bl = this.m_config != null && this.m_config.isInFlatEditor();
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper((JPanel)((Object)this), bl);
            JLabel jLabel = new JLabel();
            dBUIResourceHelper.resLabel(jLabel, (Component)this.m_txtSQL, UIBundle.get("DDL_LABEL_SQL"), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            dBUIResourceHelper.resButton(this.m_btnSave, UIBundle.get("DDL_BUTTON_SAVE"), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this.m_txtSQL);
            dBUILayoutHelper.add(jLabel);
            dBUILayoutHelper.nextRow();
            if (this.m_showRadio) {
                this.m_rdbCreate = new JRadioButton();
                this.m_rdbCreate.addActionListener(this);
                dBUIResourceHelper.resButton(this.m_rdbCreate, UIBundle.get("DDL_CREATE"), "Create");
                this.m_rdbUpdate = new JRadioButton();
                this.m_rdbUpdate.addActionListener(this);
                dBUIResourceHelper.resButton(this.m_rdbUpdate, UIBundle.get("DDL_UPDATE"), "Update");
                this.m_btnGrp = new ButtonGroup();
                this.m_btnGrp.add(this.m_rdbCreate);
                this.m_btnGrp.add(this.m_rdbUpdate);
                dBUILayoutHelper.add(this.m_rdbCreate);
                dBUILayoutHelper.add(this.m_rdbUpdate);
                dBUILayoutHelper.nextRow();
            }
            dBUILayoutHelper.add(jScrollPane, 3, 1);
            dBUILayoutHelper.add(Box.createVerticalStrut(200), 1, 1, false, false);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.add(this.m_btnSave);
            dBUILayoutHelper.getConstraints((Component)this.m_btnSave).anchor = 13;
            dBUILayoutHelper.layout();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIBundle.get("SQLFILE_TYPE"), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    DBMessageDialog.showErrorDialog(iOException, this, Level.SEVERE, null, UIBundle.get("DDL_ERROR_SAVE_TITLE"), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public static DDLGenerator getDDLGenerator(DBEditorConfig dBEditorConfig) {
        DDLGenerator dDLGenerator = null;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        if (dBObjectProvider != null) {
            dDLGenerator = dBObjectProvider.getDescriptor().getDDLGenerator(dBObjectProvider);
        }
        return dDLGenerator;
    }
}

