/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.icons.OracleIcons;

public abstract class InsightDataProvider {
    protected DBInsightProvider m_DBInsightProvider = null;
    private int m_order;

    public abstract void addItems(DBObject var1) throws CancelledException;

    protected final void setDBInsightProvider(DBInsightProvider dBInsightProvider) {
        this.m_DBInsightProvider = dBInsightProvider;
    }

    protected final DBInsightContext.FilterMode getFilterMode() {
        return this.m_DBInsightProvider.getFilterMode();
    }

    protected final String getSearchString() {
        return this.m_DBInsightProvider.getMatchingText();
    }

    protected final DBObjectProvider getProvider() {
        return this.m_DBInsightProvider.getProvider();
    }

    protected final DBObject getContextObjectAtOffset() {
        return this.m_DBInsightProvider.getContextObjectAtOffset();
    }

    protected final Class<? extends DBObject> getParentScopeClass() {
        return this.m_DBInsightProvider.getParentScopeClass();
    }

    protected final Integer getOffset() {
        return this.m_DBInsightProvider.getOffset();
    }

    protected final boolean isTopLevel(DBObject dBObject) {
        Class<? extends DBObject> clazz = this.getParentScopeClass();
        return dBObject == null || clazz != null && clazz.isAssignableFrom(dBObject.getClass());
    }

    protected final void addDBObject(DBObject dBObject) {
        if (this.isTargetClassOrPossibleParent(dBObject.getClass()) && dBObject != null && dBObject.getName() != null) {
            String string = dBObject.getName();
            if (dBObject instanceof FromObject) {
                string = this.getProvider().getInternalName(string);
            }
            if (this.accept(string)) {
                if (dBObject instanceof PlSqlSubProgram) {
                    PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)dBObject;
                    String string2 = plSqlSubProgram.getReturnTypeID() == null ? "PROCEDURE" : "FUNCTION";
                    Icon icon = DBTypeDisplayRegistry.getNodeIcon(string2);
                    String string3 = DBTypeDisplayRegistry.getSingularDisplayName(string2);
                    String string4 = this.getSubProgramDisplayValue(plSqlSubProgram, this.getProvider());
                    DBInsightData dBInsightData = new DBInsightData(string4, string3, icon, true, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd(), this.getOrder());
                    this.m_DBInsightProvider.addItem(dBInsightData);
                } else {
                    String string5 = this.getProvider().getExternalName(string);
                    String string6 = DBTypeDisplayRegistry.getSingularDisplayName(dBObject.getType());
                    Icon icon = DBTypeDisplayRegistry.getNodeIcon(dBObject.getType());
                    string5 = this.correctCase(string5);
                    DBInsightData dBInsightData = new DBInsightData(string5, string6, icon, true, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd(), this.getOrder());
                    this.m_DBInsightProvider.addItem(dBInsightData);
                }
            }
        }
    }

    protected final void addReservedWord(String string) {
        this.addWords(this.m_DBInsightProvider.getLanguage(), null, string);
    }

    protected final void addExpression(String string, Icon icon, String string2) {
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string2, (String[])new String[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!plSqlToken.isEndMarker()) {
            arrayList.add(plSqlToken.getSource());
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
        }
        this.addWords(string, icon, arrayList.toArray(new String[arrayList.size()]));
    }

    protected final void addWords(String string, Icon icon, String ... stringArray) {
        if (this.accept(stringArray[0])) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                stringBuilder.append(this.correctCase(string2));
            }
            if (icon == null) {
                icon = OracleIcons.getIcon((String)"spacer.png");
            }
            DBInsightData dBInsightData = new DBInsightData(stringBuilder.toString(), string, icon, false, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd(), this.getOrder());
            this.m_DBInsightProvider.addItem(dBInsightData);
        }
    }

    protected final boolean isTargetClass(Class clazz, boolean bl) {
        Class<? extends DBObject> clazz2 = this.m_DBInsightProvider.getTargetObjectClass();
        if (bl) {
            return clazz2 == clazz;
        }
        return clazz2 == null || clazz != null && clazz2.isAssignableFrom(clazz);
    }

    protected final boolean isTargetClassOrPossibleParent(Class clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        return this.isTargetClassOrPossibleParent(clazz, hashSet);
    }

    private boolean isTargetClassOrPossibleParent(Class<?> clazz, Set<Class> set) {
        if (this.isTargetClass(clazz, false)) {
            return true;
        }
        if (clazz == Schema.class) {
            return true;
        }
        if (DBObject.class.isAssignableFrom(clazz) && !set.contains(clazz)) {
            set.add(clazz);
            Predicate<PropertyInfo> predicate = propertyInfo -> this.isTargetClassOrPossibleParent((PropertyInfo)propertyInfo, set);
            if (Metadata.getInstance().hasSupportedProperty(clazz, null, predicate)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTargetClassOrPossibleParent(PropertyInfo propertyInfo, Set<Class> set) {
        boolean bl;
        String string = propertyInfo.getPropertyName();
        if ("parent".equals(string) || "relation".equals(string) || "table".equals(string) || "schema".equals(string)) {
            bl = false;
        } else {
            Class clazz = propertyInfo.getPropertyClass();
            bl = this.isTargetClassOrPossibleParent(clazz, set);
        }
        return bl;
    }

    protected final boolean accept(String string) {
        DBInsightContext.FilterMode filterMode = this.m_DBInsightProvider.getFilterMode();
        if (string == null) {
            return false;
        }
        if (filterMode == null) {
            return true;
        }
        if (filterMode == DBInsightContext.FilterMode.STARTS_WITH && string.startsWith(this.getSearchString())) {
            return true;
        }
        return filterMode == DBInsightContext.FilterMode.CONTAINS && string.contains(this.getSearchString());
    }

    protected final SchemaObject[] getMatchingSchemaItems(Schema schema, String ... stringArray) throws CancelledException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getFilterMode() == DBInsightContext.FilterMode.CONTAINS) {
            stringBuilder.append("%");
        }
        if (this.getFilterMode() != null) {
            stringBuilder.append(this.getSearchString());
        }
        stringBuilder.append("%");
        String string = stringBuilder.toString();
        try {
            return this.getProvider().listObjects(stringArray, schema, string);
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            this.getLogger().warning(dBException.getMessage());
            return new SchemaObject[0];
        }
    }

    protected final String getSubProgramDisplayValue(PlSqlSubProgram plSqlSubProgram, DBObjectProvider dBObjectProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = plSqlSubProgram.getName();
        if (string.contains("(")) {
            string = string.substring(0, string.indexOf("("));
        }
        stringBuilder.append(this.correctCase(dBObjectProvider.getExternalName(string)));
        String string2 = "(";
        for (PlSqlParameter plSqlParameter : plSqlSubProgram.getParameters()) {
            if (plSqlParameter.getDefaultValue() != null) continue;
            stringBuilder.append(string2);
            string2 = ",";
        }
        if (string2.equals(",")) {
            stringBuilder.append(")");
        }
        String string3 = stringBuilder.toString();
        return string3;
    }

    protected final String correctCase(String string) {
        if (string == null || string.startsWith("\"")) {
            return string;
        }
        if (this.m_DBInsightProvider.getMakeLower().booleanValue()) {
            return string.toLowerCase();
        }
        return string.toUpperCase();
    }

    protected final void setOrder(int n) {
        this.m_order = n;
    }

    protected int getOrder() {
        return this.m_order;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }
}

