/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.util.SwingUtils;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";
    private BorderLayout m_layMain = new BorderLayout();
    private JMultiLineLabel m_lblMsg = new JMultiLineLabel();
    private JButton m_btnBack = new JButton();
    private JButton m_btnForward = new JButton();
    private JLabel m_count = new JLabel();
    private JPanel m_pnlBottom = new JPanel();
    private GridBagLayout m_layBottom = new GridBagLayout();
    private JPanel m_pnlButtons = new JPanel();
    private GridLayout m_layButtons = new GridLayout();
    private List m_errs;
    private int m_idx;
    private BaseMessageDialog m_dialog;
    private int m_type;

    protected SQLErrorDialog() {
    }

    protected boolean isConfirm() {
        return this.m_type == 4;
    }

    private void setError(SQLException sQLException) {
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        while (sQLException != null) {
            arrayList.add(sQLException);
            sQLException = sQLException.getNextException();
        }
        this.setErrors(arrayList);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BACK_CMD.equals(string)) {
            --this.m_idx;
            this.update();
        } else if (FWD_CMD.equals(string)) {
            ++this.m_idx;
            this.update();
        }
    }

    protected void setErrors(List list) {
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_errs = list;
        this.m_idx = this.m_errs.size() > 0 ? 0 : -1;
        this.m_pnlBottom.setVisible(this.m_errs.size() > 1);
        this.update();
    }

    private void update() {
        this.m_btnBack.setEnabled(this.m_idx > 0);
        this.m_btnForward.setEnabled(this.m_idx < this.m_errs.size() - 1);
        this.m_count.setText(UIBundle.format("SQL_EXCEPTION_COUNT", this.m_idx + 1, this.m_errs.size()));
        Exception exception = this.m_idx != -1 ? (Exception)this.m_errs.get(this.m_idx) : null;
        this.updateExceptionComponent(exception);
        this.validate();
        this.repaint();
    }

    protected void updateExceptionComponent(Exception exception) {
        SQLException sQLException = (SQLException)exception;
        Object object = sQLException.getLocalizedMessage();
        if (object != null && !((String)object).endsWith("\n")) {
            object = (String)object + "\n";
        }
        String string = sQLException != null ? UIBundle.format("SQL_EXCEPTION_MSG", object, Integer.toString(sQLException.getErrorCode())) : UIBundle.get("SQL_EXCEPTION_UNKNOWN_MSG");
        this.m_lblMsg.setText(string);
    }

    protected Component getExceptionComponent() {
        this.m_lblMsg.setPreferredAspectRatio(5.0f);
        return this.m_lblMsg;
    }

    private void layoutComponents() {
        this.setLayout(this.m_layMain);
        this.add(Box.createHorizontalStrut(300), "North");
        ResourceUtils.resButton((AbstractButton)this.m_btnBack, (String)UIBundle.get("SQL_EXCEPTION_BUTTON_BACK"));
        this.m_btnBack.setActionCommand(BACK_CMD);
        this.m_btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnForward, (String)UIBundle.get("SQL_EXCEPTION_BUTTON_NEXT"));
        this.m_btnForward.setActionCommand(FWD_CMD);
        this.m_btnForward.addActionListener(this);
        this.m_pnlBottom.setLayout(this.m_layBottom);
        this.m_pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.m_layButtons.setColumns(2);
        this.m_layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), "Center");
        this.m_pnlButtons.setLayout(this.m_layButtons);
        this.m_pnlButtons.add((Component)this.m_btnBack, null);
        this.m_pnlButtons.add((Component)this.m_btnForward, null);
        this.m_pnlBottom.add((Component)this.m_count, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBottom.add((Component)this.m_pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlBottom, "South");
    }

    protected void runErrorDialog(Component component, String string, String string2) {
        this.runDialog(component, string, string2, 3);
    }

    protected boolean runConfirmDialog(Component component, String string, String string2) {
        return this.runDialog(component, string, string2, 4);
    }

    private boolean runDialog(Component component, String string, String string2, int n) {
        if (string == null) {
            string = UIBundle.get("DB_EXCEPTION_DEFAULT_TITLE");
        }
        this.m_dialog = BaseMessageDialog.createMessageDialogImpl((Component)(component == null ? SwingUtils.getMainWindow() : component), (String)string, (int)n);
        this.m_type = n;
        this.update();
        if (string2 != null) {
            this.m_dialog.setHelpTopic(string2);
            this.m_dialog.setButtonMask(this.m_dialog.getButtonMask() + 4);
        }
        this.m_dialog.setDefaultButton(1);
        this.m_dialog.setResizable(true);
        this.m_dialog.setMessage((Object)this);
        this.m_dialog.setMinimumSize(new Dimension(400, 250));
        this.m_dialog.setMaximumInitialSize(new Dimension(400, 600));
        this.m_dialog.setName(this.getClass().getSimpleName());
        return this.m_dialog.runDialog();
    }

    public static void showErrorDialog(Component component, String string, SQLException sQLException) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(component, string, null);
    }
}

