/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextArea;
import javax.swing.text.Caret;

public class ReadOnlyTextArea
extends JTextArea {
    public ReadOnlyTextArea() {
        this(false);
    }

    public ReadOnlyTextArea(boolean bl) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        this.setOpaque(true);
        if (!bl) {
            this.setBorder(null);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Caret caret = ReadOnlyTextArea.this.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.setCaretPosition(0);
    }
}

