/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameEditor;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.Metadata;

public class NameAndSchemaEditor<T extends SchemaObject>
extends NameEditor<T> {
    private JCheckBox m_chkPlsqlLowerCase;
    private Schema m_lastSchema;
    private Schema m_lastNotPublicSchema;
    private Schema m_publicSchema;

    @Override
    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        ComponentWrapper componentWrapper;
        if (this.getProvider().getPropertyManager().supportsProperty(this.getEditorConfig().getObjectType(), "public")) {
            componentWrapper = this.getOrCreateWrapper("public");
            componentWrapper.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NameAndSchemaEditor.this.setSchema(propertyChangeEvent.getNewValue(), true);
                }
            });
            this.getComponentFactory().getResourceHelper().setName((Component)componentWrapper.getActiveComponent(), "Public");
            dBUILayoutHelper.add(componentWrapper);
            dBUILayoutHelper.nextRow();
        }
        componentWrapper = this.getOrCreateWrapper("schema");
        componentWrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NameAndSchemaEditor.this.checkSchema((Schema)propertyChangeEvent.getNewValue());
            }
        });
        this.getComponentFactory().getResourceHelper().setName((Component)componentWrapper.getActiveComponent(), "Schema");
        dBUILayoutHelper.add(componentWrapper.getLabel());
        dBUILayoutHelper.add(componentWrapper.getComponent(), 1, 1, true, false);
        dBUILayoutHelper.nextRow();
        super.layoutComponents(dBUILayoutHelper);
        if (!this.isInFlatEditor() && this.getUpdatedObject() instanceof PlSqlSourceObject) {
            dBUILayoutHelper.nextRow();
            this.m_chkPlsqlLowerCase = new JCheckBox();
            this.getComponentFactory().getResourceHelper().resButton(this.m_chkPlsqlLowerCase, UIBundle.get("LABEL_LOWERCASE"), "PlSqlLowercase");
            dBUILayoutHelper.add(this.m_chkPlsqlLowerCase, 2, 1, false, false);
        }
    }

    private void setLastSchema(Schema schema) {
        if (schema != null) {
            this.m_lastSchema = schema;
            if (!DBUtil.areNamesAndTypesEqual((DBObject)schema, (DBObject)this.getPublicSchema())) {
                this.m_lastNotPublicSchema = schema;
            }
        }
    }

    private void checkSchema(Schema schema) {
        SchemaObject schemaObject = (SchemaObject)this.getUpdatedObject();
        if (schema != null && !DBUtil.areNamesAndTypesEqual((DBObject)this.m_lastSchema, (DBObject)schema) && !this.isEditing() && schemaObject.getName().equals(this.getInitialName())) {
            String string = this.getUniqueNameWithinSchema(schema);
            schemaObject.setName(string);
            ((JTextField)this.getOrCreateWrapper("name").getActiveComponent()).setText(string);
            this.setInitialName(string);
            this.setLastSchema(schema);
        }
    }

    private String getUniqueNameWithinSchema(Schema schema) {
        Class clazz = Metadata.getInstance().getObjectClass(((SchemaObject)this.getUpdatedObject()).getType());
        DBObject dBObject = null;
        if (SchemaObject.class.isAssignableFrom(clazz)) {
            dBObject = this.getProvider().getObjectFactory().newObject(clazz, (DBObject)schema);
        }
        return dBObject == null ? null : dBObject.getName();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.setLastSchema(((SchemaObject)this.getUpdatedObject()).getSchema());
        if (this.m_chkPlsqlLowerCase != null) {
            this.m_chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
            this.m_chkPlsqlLowerCase.setEnabled(this.isEditable());
        }
    }

    private void setSchema(Object object, boolean bl) {
        Schema schema;
        boolean bl2 = Boolean.TRUE.equals(object);
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("schema");
        Schema schema2 = schema = bl2 ? this.getPublicSchema() : this.m_lastNotPublicSchema;
        if (schema == null) {
            try {
                schema = this.getProvider().getDefaultSchema();
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).warning(dBException.getMessage());
            }
        }
        if (bl) {
            ((SchemaObject)this.getUpdatedObject()).setSchema(schema);
        }
        componentWrapper.resetPropertyValue(schema);
        this.checkSchema(schema);
        this.setLastSchema(schema);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_chkPlsqlLowerCase != null) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this.m_chkPlsqlLowerCase.isSelected());
        }
    }

    private Schema getPublicSchema() {
        if (this.m_publicSchema == null) {
            try {
                this.m_publicSchema = this.getProvider().getSchema(this.getPublicSchemaName());
            }
            catch (DBException dBException) {
                this.getLogger().warning("Error finding PUBLIC schema" + dBException.getMessage());
            }
            if (this.m_publicSchema == null) {
                this.m_publicSchema = new Schema(this.getPublicSchemaName());
            }
        }
        return this.m_publicSchema;
    }

    private String getPublicSchemaName() {
        return this.getProvider().getDescriptor().getPublicSchemaName();
    }
}

