/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.util.ModelUtil;

public class NameAndSchemaAdvancedEditor<T extends SchemaObject>
extends NameAndSchemaEditor<T> {
    protected static final String SIMPLE = "Simple";
    private JCheckBox m_advanced;
    private boolean m_enteredOnce = false;

    @Override
    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        Object[] objectArray;
        super.layoutComponents(dBUILayoutHelper);
        boolean bl = false;
        if (!this.isInFlatEditor() && !this.isEditing() && !this.isNewFromTemplate() && ModelUtil.hasNonNullElement((Object[])(objectArray = this.getSimpleNavigables()))) {
            String string = this.getEditorConfig().getStartPage();
            if (string == null) {
                bl = true;
            } else {
                for (Object object : objectArray) {
                    if (object == null || !ModelUtil.areEqual((Object)object.getShortLabel(), (Object)string)) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            this.m_advanced = new JCheckBox();
            this.m_advanced.setSelected(false);
            this.getComponentFactory().getResourceHelper().resButton(this.m_advanced, UIBundle.get("TABLE_INFO_ADVANCED"), "Advanced");
            dBUILayoutHelper.add(this.m_advanced);
            dBUILayoutHelper.getConstraints((Component)this.m_advanced).gridy = 0;
            this.m_advanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NameAndSchemaAdvancedEditor.this.advancedChange();
                }
            });
            if (this.getAdvancedPreference()) {
                this.m_advanced.setSelected(true);
            } else {
                this.m_advanced.setSelected(false);
                try {
                    this.showSimplePanel();
                }
                catch (TraversalException traversalException) {
                    this.getLogger().log(Level.WARNING, "traversal exception on init", traversalException);
                }
            }
        }
    }

    protected void showSimplePanel() throws TraversalException {
        PanelLibrary.ensureSimplePanels(this.getDataContext(), null);
    }

    protected final Navigable[] getSimpleNavigables() {
        List<Navigable> list = this.getPanelLibrary().getSimpleNavigables();
        return list == null ? new Navigable[]{} : list.toArray(new Navigable[list.size()]);
    }

    protected void showAdvancedPanel() throws TraversalException {
        PanelLibrary.ensurePanels(this.getDataContext(), null);
    }

    protected boolean isAdvancedLayout() {
        return this.m_advanced == null || this.m_advanced.isSelected();
    }

    private void advancedChange() {
        if (this.m_advanced.isSelected()) {
            try {
                this.showAdvancedPanel();
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                this.m_advanced.setSelected(false);
            }
        } else {
            try {
                this.showSimplePanel();
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                this.m_advanced.setSelected(true);
            }
        }
    }

    private boolean getAdvancedPreference() {
        DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
        if (databaseIdePreferences != null) {
            return databaseIdePreferences.isAdvancedView(this.getPanelLibrary().getType());
        }
        return false;
    }

    @Override
    @Deprecated
    public void validatePanelChange(TraversableContext traversableContext) throws TraversalException {
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
        if (databaseIdePreferences != null && this.m_advanced != null) {
            databaseIdePreferences.setAdvancedView(this.getPanelLibrary().getType(), this.m_advanced.isSelected());
        }
    }

    private boolean isNewFromTemplate() {
        SystemObject systemObject = this.getEditorConfig().getUpdatedObject();
        return systemObject != null && TemplateExpander.isPendingObject((DBObject)systemObject);
    }
}

