/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.Assert;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.util.ModelUtil;

public class DBObjectPicker
extends AbstractTreePicker {
    protected static final Transferable[] EMPTY = new DBObjectTransferable[0];
    protected DBObjectRenderer m_dbRenderer = new DBObjectRenderer();
    protected DefaultMutableTreeNode m_top = new DefaultMutableTreeNode("DB_OBJECTS");
    protected DefaultTreeModel m_treeModel = new DefaultTreeModel(this.m_top);
    protected JTree m_tree = new JTree(this.m_treeModel);
    protected TreeNodeMaker m_nodeMaker = new TreeNodeMaker(this.m_tree);
    protected boolean m_remove;

    public DBObjectPicker(boolean bl, boolean bl2) {
        this.setTree(this.m_tree);
        this.m_remove = bl2;
        this.m_nodeMaker.setShowChildren(bl);
        this.setupTree();
    }

    public TreeNodeMaker getNodeMaker() {
        return this.m_nodeMaker;
    }

    public void reloadTree() {
        this.m_treeModel.reload();
    }

    private void setupTree() {
        this.m_tree.setRootVisible(false);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_tree.setShowsRootHandles(this.m_nodeMaker.getShowChildren());
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.getSelectionModel().setSelectionMode(4);
    }

    public void clear() {
        this.m_tree.removeAll();
        this.m_treeModel.reload();
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_top, this.m_top.getChildCount());
    }

    public void addDBObjects(DBObject[] dBObjectArray) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (dBObjectArray[i] == null) continue;
            this.findOrAddChild(this.m_top, dBObjectArray[i], null);
        }
    }

    public void addDBObjectPaths(DBObject[][] dBObjectArray) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.m_top;
            for (int j = 0; j < dBObjectArray[i].length; ++j) {
                defaultMutableTreeNode = this.findOrAddChild(defaultMutableTreeNode, dBObjectArray[i][j], null);
            }
        }
    }

    protected DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode defaultMutableTreeNode, DBObject dBObject, List list) {
        return this.findOrAddChild(defaultMutableTreeNode, dBObject, list, false);
    }

    private DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode defaultMutableTreeNode, DBObject dBObject, List list, boolean bl) {
        Serializable serializable;
        boolean bl2 = false;
        int n = defaultMutableTreeNode.getChildCount();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            serializable = (DefaultMutableTreeNode)enumeration.nextElement();
            int n3 = DBUtil.getNameComparator().compare(dBObject, (DBObject)serializable.getUserObject());
            if (n3 == 0) {
                if (bl) {
                    n = n2;
                    this.m_treeModel.removeNodeFromParent((MutableTreeNode)((Object)serializable));
                    break;
                }
                return serializable;
            }
            if (n3 < 1 && !bl2) {
                n = n2;
                bl2 = true;
            }
            ++n2;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_nodeMaker.createTreeNode(dBObject);
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        serializable = new TreePath(defaultMutableTreeNode2.getPath());
        if (list != null) {
            list.add(serializable);
        }
        return defaultMutableTreeNode2;
    }

    private DBObject[] trimPath(Object[] objectArray) {
        int n;
        int n2 = -1;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != this.m_top.getUserObject()) continue;
            n2 = n;
            break;
        }
        n = objectArray.length - (n2 + 1);
        DBObject[] dBObjectArray = new DBObject[n];
        System.arraycopy(objectArray, n2 + 1, dBObjectArray, 0, n);
        return dBObjectArray;
    }

    private void removeFromParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (defaultMutableTreeNode != null && defaultMutableTreeNode != this.m_top && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) != null) {
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
            if (defaultMutableTreeNode2.getChildCount() < 1 && defaultMutableTreeNode2 != this.m_top) {
                this.removeFromParent(defaultMutableTreeNode2);
            } else {
                this.m_treeModel.reload(defaultMutableTreeNode2);
            }
        }
    }

    public void setSelectedItems(DBObject[] dBObjectArray) {
        TreeSelectionModel treeSelectionModel = this.m_tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (dBObjectArray[i] == null) continue;
            this.setSelected(dBObjectArray[i], this.m_top, treeSelectionModel);
        }
    }

    private void setSelected(DBObject dBObject, DefaultMutableTreeNode defaultMutableTreeNode, TreeSelectionModel treeSelectionModel) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!DBUtil.areNamesAndTypesEqual((DBObject)dBObject, (DBObject)((DBObject)defaultMutableTreeNode2.getUserObject()))) continue;
            treeSelectionModel.addSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            return;
        }
    }

    @Override
    public boolean isSelectableItemPresent() {
        return this.m_top.getChildCount() > 0;
    }

    @Override
    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (this.m_remove) {
            TreePath[] treePathArray;
            int n;
            this.m_tree.clearSelection();
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < transferableArray.length; ++n) {
                try {
                    treePathArray = (TreePath[])transferableArray[n];
                    DefaultMutableTreeNode defaultMutableTreeNode = this.m_top;
                    DBObject[] dBObjectArray = treePathArray.getPath();
                    if (dBObjectArray != null && dBObjectArray.length > 1) {
                        for (int i = 0; i < dBObjectArray.length; ++i) {
                            defaultMutableTreeNode = this.findOrAddChild(defaultMutableTreeNode, dBObjectArray[i], null, i == dBObjectArray.length - 1);
                        }
                        continue;
                    }
                    DBObject dBObject = treePathArray.getDBObject();
                    this.findOrAddChild(defaultMutableTreeNode, dBObject, arrayList, true);
                    continue;
                }
                catch (Exception exception) {
                    Assert.printStackTrace((Throwable)exception);
                }
            }
            n = arrayList.size();
            if (n > 0) {
                treePathArray = arrayList.toArray(new TreePath[n]);
                this.m_tree.setSelectionPaths(treePathArray);
            }
        }
        return true;
    }

    @Override
    public void removeSelectedItems() {
        if (this.m_remove) {
            int n;
            TreePath treePath = null;
            int[] nArray = this.m_tree.getSelectionRows();
            if (nArray != null && nArray.length > 0) {
                Arrays.sort(nArray);
                int n2 = nArray[nArray.length - 1];
                if (n2 == this.m_tree.getRowCount() - 1) {
                    n = n2;
                    while (Arrays.binarySearch(nArray, --n) >= 0) {
                    }
                    if (n >= 0) {
                        treePath = this.m_tree.getPathForRow(n);
                    }
                } else {
                    treePath = this.m_tree.getPathForRow(n2 + 1);
                }
            }
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            for (n = 0; treePathArray != null && n < treePathArray.length; ++n) {
                if (treePathArray[n] == null) continue;
                this.removeFromParent((DefaultMutableTreeNode)treePathArray[n].getLastPathComponent());
            }
            if (this.m_tree.getRowCount() > 0) {
                if (treePath == null) {
                    this.m_tree.setSelectionRow(0);
                } else {
                    this.m_tree.setSelectionPath(treePath);
                }
            }
        }
    }

    @Override
    public void removeAllSelectableItems() {
        if (this.m_remove) {
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
        }
    }

    @Override
    public Transferable createTransferable(TreePath treePath) {
        Object[] objectArray;
        DBObjectTransferable dBObjectTransferable = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ChildDBObject && !(object instanceof SourceObject) && ((ChildDBObject)object).getParent() == null && (objectArray = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject()) instanceof DBObject) {
            ((ChildDBObject)object).setParent((DBObject)objectArray);
        }
        objectArray = defaultMutableTreeNode.getUserObjectPath();
        if (object != null && object instanceof DBObject) {
            if (objectArray == null) {
                dBObjectTransferable = new DBObjectTransferable((DBObject)object);
            } else {
                DBObject[] dBObjectArray = this.trimPath(objectArray);
                dBObjectTransferable = new DBObjectTransferable((DBObject)object, dBObjectArray);
            }
        }
        return dBObjectTransferable;
    }

    @Override
    public Transferable[] getAllSelectableItems() {
        ArrayList<DBObjectTransferable> arrayList = new ArrayList<DBObjectTransferable>();
        Enumeration<TreeNode> enumeration = this.m_top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            DBObject dBObject = (DBObject)defaultMutableTreeNode.getUserObject();
            arrayList.add(new DBObjectTransferable(dBObject));
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return EMPTY;
    }

    @Override
    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] transferableArray = this.getSelectedItems();
        if (transferableArray != null) {
            DataFlavor[] dataFlavorArray = new DataFlavor[transferableArray.length];
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                dataFlavorArray[i] = ((DBObjectTransferable)transferableArray[i]).getPrimaryFlavor();
            }
            return dataFlavorArray;
        }
        return null;
    }

    @Override
    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            Class<?> clazz;
            if (dataFlavorArray[i] == null || !ModelUtil.areEqual(clazz = dataFlavorArray[i].getDefaultRepresentationClass(), DBObjectTransferable.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        super.valueChanged(treeSelectionEvent);
    }
}

