/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public abstract class AbstractTreePicker
implements MouseListener,
FocusListener,
TreeSelectionListener,
ItemPicker {
    private PropertyChangeSupport m_pcs;
    private ActionListener m_actionListener;
    private JTree m_tree;
    private JScrollPane m_component;
    private ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar();

    public AbstractTreePicker() {
    }

    public AbstractTreePicker(JTree jTree) {
        this.setTree(jTree);
    }

    public void setTree(JTree jTree) {
        this.m_tree = jTree;
        this.m_component = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AbstractTreePicker.this.handleDefaultAction(AbstractTreePicker.this.m_tree.getSelectionPath());
                if (!bl && AbstractTreePicker.this.m_actionListener != null) {
                    AbstractTreePicker.this.m_actionListener.actionPerformed(new ActionEvent(AbstractTreePicker.this, 1001, null));
                }
            }
        };
        this.m_tree.registerKeyboardAction(actionListener, keyStroke, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(65, 128);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTreePicker.this.m_tree.setSelectionInterval(0, AbstractTreePicker.this.m_tree.getRowCount());
            }
        };
        this.m_tree.registerKeyboardAction(actionListener2, keyStroke2, 0);
        this.m_compTitleBar.setComponent((JComponent)this.m_component);
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public boolean isItemSelected() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        for (int i = 0; treePathArray != null && i < treePathArray.length; ++i) {
            if (this.createTransferable(treePathArray[i]) == null) continue;
            return true;
        }
        return false;
    }

    public void deselectAll() {
        this.m_tree.getSelectionModel().setSelectionPath(null);
    }

    public Transferable[] getSelectedItems() {
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            for (int i = 0; i < treePathArray.length; ++i) {
                Transferable transferable = this.createTransferable(treePathArray[i]);
                if (transferable == null) continue;
                arrayList.add(transferable);
            }
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return null;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public JScrollPane getScrollPane() {
        return this.m_component;
    }

    public Component getComponent() {
        return this.m_compTitleBar;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] transferableArray = this.getSelectedItems();
        if (transferableArray != null) {
            DataFlavor[] dataFlavorArray = new DataFlavor[transferableArray.length];
            for (int i = 0; i < transferableArray.length; ++i) {
                dataFlavorArray[i] = transferableArray[i] == null ? null : transferableArray[i].getTransferDataFlavors()[0];
            }
            return dataFlavorArray;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        return true;
    }

    public abstract Transferable[] getAllSelectableItems();

    public abstract boolean addSelectedItems(Transferable[] var1);

    public abstract void removeSelectedItems();

    public abstract void removeAllSelectableItems();

    public abstract Transferable createTransferable(TreePath var1);

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, actionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_pcs == null) {
            this.m_pcs = new PropertyChangeSupport(this);
        }
        this.m_pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, actionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_pcs != null) {
            this.m_pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected boolean handleDefaultAction(TreePath treePath) {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_actionListener != null) {
            Transferable transferable;
            Object object;
            TreePath treePath;
            int n = this.m_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                int n2 = mouseEvent.getModifiers();
                if ((n2 & 2) != 2 && (n2 & 1) != 1) {
                    this.deselectAll();
                }
            } else if (mouseEvent.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(mouseEvent) && !this.handleDefaultAction(treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) && (!((object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) || ((DefaultMutableTreeNode)object).isLeaf()) && (transferable = this.createTransferable(treePath)) != null) {
                this.m_actionListener.actionPerformed(new ActionEvent(this, mouseEvent.getID(), null, mouseEvent.getModifiers()));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.m_tree.getSelectionCount() == 0 && this.m_tree.getRowCount() > 0) {
            this.m_tree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.m_pcs != null) {
            this.m_pcs.firePropertyChange("selection", null, null);
        }
    }

    public void setTitleLabel(String string, String string2) {
        JLabel jLabel = new JLabel();
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(string2);
        dBUIResourceHelper.resLabel(jLabel, (Component)this.m_compTitleBar, string, "Available");
        this.m_compTitleBar.setLabel(jLabel);
    }

    public void setTitleControlBar(ControlBar controlBar) {
        this.m_compTitleBar.setControlBar(controlBar);
    }
}

