/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.util.ModelUtil;

public class DBObjectTransferable
implements Transferable {
    private DBObject m_obj;
    private DBObject[] m_path;
    private boolean m_incKids;
    private DataFlavor[] m_flavors;
    private static final Map<String, DataFlavor> s_flavors = new HashMap<String, DataFlavor>();

    public DBObjectTransferable(DBObject dBObject) {
        this(dBObject, null, false);
    }

    public DBObjectTransferable(DBObject dBObject, boolean bl) {
        this(dBObject, null, bl);
    }

    public DBObjectTransferable(DBObject dBObject, DBObject[] dBObjectArray) {
        this(dBObject, dBObjectArray, false);
    }

    public DBObjectTransferable(DBObject dBObject, DBObject[] dBObjectArray, boolean bl) {
        this.m_obj = dBObject;
        this.m_path = dBObjectArray;
        this.m_incKids = bl;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public DBObject[] getPath() {
        if (this.m_path == null) {
            this.m_path = new DBObject[]{this.m_obj};
        }
        return this.m_path;
    }

    public DataFlavor getPrimaryFlavor() {
        return DBObjectTransferable.getDataFlavor(this.m_obj.getType());
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.m_flavors == null) {
            if (this.m_incKids && this.m_obj instanceof Relation) {
                if (this.m_obj instanceof Table) {
                    this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor("TABLE"), DBObjectTransferable.getDataFlavor("COLUMN"), DBObjectTransferable.getDataFlavor("CONSTRAINT"), DBObjectTransferable.getDataFlavor("INDEX")};
                } else if (this.m_obj instanceof View) {
                    this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor("VIEW"), DBObjectTransferable.getDataFlavor("COLUMN"), DBObjectTransferable.getDataFlavor("CONSTRAINT")};
                }
            } else {
                this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor(this.m_obj.getType())};
            }
        }
        return this.m_flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.getDefaultRepresentationClass() == DBObjectTransferable.class;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        String string;
        if (!s_flavors.containsValue(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        String string2 = dataFlavor.getHumanPresentableName();
        if (ModelUtil.areEqual((Object)string2, (Object)(string = this.m_obj.getType()))) {
            return this.m_obj;
        }
        if (this.m_obj instanceof Relation && this.m_incKids) {
            if ("COLUMN".equals(string2)) {
                return ((Relation)this.m_obj).getColumns();
            }
            if ("CONSTRAINT".equals(string2)) {
                return ((Relation)this.m_obj).getConstraints();
            }
            if (this.m_obj instanceof Table && "INDEX".equals(string2)) {
                return ((Table)this.m_obj).getIndexes();
            }
        }
        return null;
    }

    public static DataFlavor getDataFlavor(String string) {
        DataFlavor dataFlavor = s_flavors.get(string);
        if (dataFlavor == null) {
            dataFlavor = new DataFlavor(DBObjectTransferable.class, string);
            s_flavors.put(string, dataFlavor);
        }
        return dataFlavor;
    }
}

