/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.view.View;
import oracle.javatools.db.ora.OracleDatabase;

public class DBObjectActions {
    public static IdeAction getNewObjectAction() {
        return IdeAction.find((String)"oracle.ide.db.NewObject");
    }

    public static IdeAction getDuplicateAction() {
        return IdeAction.find((String)"oracle.ide.db.DuplicateObject");
    }

    public static IdeAction getFindOrCreateBodyAction() {
        return IdeAction.find((String)"oracle.ide.db.FindOrCreateBody");
    }

    public static IdeAction getSynchronizeSpecAndBody() {
        return IdeAction.find((String)"oracle.ide.db.SynchronizeSpecAndBody");
    }

    public static IdeAction getTestQueryAction() {
        return IdeAction.find((String)"oracle.ide.db.TestQuery");
    }

    public static IdeAction getPropertiesAction() {
        return IdeActions.getEditPropertiesAction();
    }

    public static final boolean addNewObjectMenuItem(ContextMenu contextMenu) {
        DBObjectTypeNode dBObjectTypeNode;
        boolean bl = false;
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view != null && !((dBObjectTypeNode = DBObjectNodeUtil.getSelectedElement(context, DBObjectTypeNode.class)) instanceof DBObjectNode)) {
            String string = DBObjectNodeUtil.normalizeType(dBObjectTypeNode);
            DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(dBObjectTypeNode);
            if (dBEditorFactory != null && (DBObjectNodeUtil.findProvider(dBObjectTypeNode) instanceof OracleDatabase || dBEditorFactory.canCreateDBObject(dBObjectTypeNode))) {
                IdeAction ideAction = DBObjectActions.getNewObjectAction();
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
                Icon icon = DBTypeDisplayRegistry.getNodeIcon(string);
                jMenuItem.setIcon(icon);
                String string2 = DBTypeDisplayRegistry.getNewMenuItemText(string);
                jMenuItem.setText(StringUtils.stripMnemonic((String)string2));
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
                contextMenu.add((Component)jMenuItem, 1.0f);
                bl = true;
            }
        }
        return bl;
    }
}

