/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.ShowAllProvider;

final class ResultListRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel name = new JLabel();
    private JLabel location = new JLabel();
    private static ResultListRenderer INSTANCE = new ResultListRenderer();
    private static final Font labelFont = UIManager.getFont("Label.font");
    private static final Font italicFont = UIManager.getFont("Label.font").deriveFont(2);

    private ResultListRenderer() {
        this.name.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        this.location.setFont(this.location.getFont().deriveFont(10.0f));
        this.setLayout(new BorderLayout());
        this.add((Component)this.name, "Before");
        this.add((Component)this.location, "Center");
    }

    public static ResultListRenderer getInstance() {
        return INSTANCE;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Result) {
            Result result = (Result)value;
            this.name.setText(result.displayText());
            this.name.setIcon(result.displayIcon());
            String loc = result.displayLocation();
            if (loc != null && loc.length() > 0) {
                this.location.setText(" - " + loc);
            } else {
                this.location.setText("");
            }
            this.name.setFont(result.provider() instanceof ShowAllProvider ? italicFont : labelFont);
        }
        this.setOpaque(isSelected);
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.name.setForeground(isSelected ? list.getSelectionForeground() : UIManager.getColor("Label.foreground"));
        this.location.setForeground(isSelected ? list.getSelectionForeground() : UIManager.getColor(ColorProvider.LOCATION_FOREGROUND));
        return this;
    }
}

