/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeySplines;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;

public class KeyFrames {
    private KeyValues keyValues;
    private KeyTimes keyTimes;
    private KeySplines keySplines;
    private InterpolationType interpolationType;

    public KeyFrames(KeyValues keyValues) {
        this.init(keyValues, null, null, InterpolationType.LINEAR);
    }

    public KeyFrames(KeyValues keyValues, InterpolationType interpolationType) {
        this.init(keyValues, null, null, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes, InterpolationType interpolationType) {
        this.init(keyValues, null, keyTimes, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeySplines keySplines, KeyTimes keyTimes, InterpolationType interpolationType) {
        this.init(keyValues, keySplines, keyTimes, interpolationType);
    }

    public KeyFrames(KeyValues keyValues, KeySplines keySplines) {
        if (keySplines != null) {
            this.init(keyValues, keySplines, null, InterpolationType.NONLINEAR);
        } else {
            this.init(keyValues, keySplines, null, InterpolationType.LINEAR);
        }
    }

    private void init(KeyValues keyValues, KeySplines keySplines, KeyTimes keyTimes, InterpolationType interpolationType) {
        if (keyTimes == null) {
            float f;
            int n = keyValues.getSize();
            float[] fArray = new float[n];
            fArray[0] = f = 0.0f;
            for (int i = 1; i < n - 1; ++i) {
                fArray[i] = f += 1.0f / (float)(n - 1);
            }
            fArray[n - 1] = 1.0f;
            this.keyTimes = new KeyTimes(fArray);
        } else {
            this.keyTimes = keyTimes;
        }
        this.keyValues = keyValues;
        this.keySplines = keySplines;
        this.interpolationType = interpolationType;
        if (interpolationType == InterpolationType.NONLINEAR && keySplines == null) {
            throw new IllegalArgumentException("NONLINEAR interpolation requires KeySplines");
        }
        if (keyValues.getSize() != this.keyTimes.getSize()) {
            throw new IllegalArgumentException("keyValues and keyTimes must be of equal size");
        }
        if (keySplines != null && keySplines.getSize() != this.keyTimes.getSize() - 1) {
            throw new IllegalArgumentException("keySplines must have a size equal to the one less than the size of keyValues");
        }
    }

    public Class getType() {
        return this.keyValues.getType();
    }

    KeyValues getKeyValues() {
        return this.keyValues;
    }

    KeySplines getKeySplines() {
        return this.keySplines;
    }

    KeyTimes getKeyTimes() {
        return this.keyTimes;
    }

    public void setValue(Object object, Method method, float f) {
        int n = this.keyTimes.getInterval(f);
        float f2 = this.keyTimes.getTime(n);
        if (this.interpolationType == InterpolationType.DISCRETE) {
            if (f < 1.0f) {
                this.keyValues.setValue(object, method, n);
            } else {
                this.keyValues.setValue(object, method, this.keyTimes.getSize() - 1);
            }
        } else {
            float f3 = this.keyTimes.getTime(n + 1);
            float f4 = (f - f2) / (f3 - f2);
            if (this.interpolationType == InterpolationType.NONLINEAR) {
                f4 = this.keySplines.interpolate(n, f4);
            }
            this.keyValues.setValue(object, method, n, n + 1, f4);
        }
    }

    public static enum InterpolationType {
        LINEAR,
        DISCRETE,
        NONLINEAR;

    }
}

