/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing;

public class Envelope {
    private double repeatCount;
    private int begin;
    private RepeatBehavior repeatBehavior;
    private EndBehavior endBehavior;

    public Envelope(double d, int n, RepeatBehavior repeatBehavior, EndBehavior endBehavior) {
        if (n < 0 || endBehavior == null || d != -1.0 && d <= 0.0) {
            String string = "Errors: ";
            if (n < 0) {
                string = string + "begin " + n + " cannot be negative\n";
            }
            if (endBehavior == null) {
                string = string + "endBehavior cannot be null\n";
            }
            if (d != -1.0 && d <= 0.0) {
                string = string + "cannot have zero or negative value of repeatCount (" + d + ")\n";
            }
            throw new IllegalArgumentException(string);
        }
        this.repeatCount = d;
        this.begin = n;
        this.repeatBehavior = repeatBehavior;
        this.endBehavior = endBehavior;
    }

    public double getRepeatCount() {
        return this.repeatCount;
    }

    public int getBegin() {
        return this.begin;
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    public static enum RepeatBehavior {
        FORWARD,
        REVERSE;

    }

    public static enum EndBehavior {
        HOLD,
        RESET;

    }
}

