/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.SpoofaxAstToGraphQuery;
import oracle.pgql.lang.TranslationContext;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.util.SqlDateTimeFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.TermType;

public class CommonTranslationUtil {
    private static int LOCAL_OR_SCHEMA_QUALIFIED_NAME_SCHEMA_NAME = 0;
    private static int LOCAL_OR_SCHEMA_QUALIFIED_NAME_LOCAL_NAME = 1;
    private static final int POS_EXP_PLUS_TYPE_EXP = 0;
    private static final int POS_BINARY_EXP_LEFT = 0;
    private static final int POS_BINARY_EXP_RIGHT = 1;
    private static final int POS_UNARY_EXP = 0;
    private static final int POS_TERNARY_EXP1 = 0;
    private static final int POS_TERNARY_EXP2 = 1;
    private static final int POS_TERNARY_EXP3 = 2;
    private static final int POS_AGGREGATE_DISTINCT = 0;
    private static final int POS_AGGREGATE_EXP = 1;
    private static final int POS_AGGREGATE_SEPARATOR = 2;
    private static final int POS_VARREF_VARNAME = 0;
    private static final int POS_VARREF_ORIGIN_OFFSET = 1;
    private static final int POS_PROPREF_VARREF = 0;
    private static final int POS_PROPREF_PROPNAME = 1;
    private static final int POS_CAST_EXP = 0;
    private static final int POS_CAST_TARGET_TYPE_NAME = 1;
    private static final int POS_EXISTS_SUBQUERY = 0;
    private static final int POS_SCALARSUBQUERY_SUBQUERY = 0;
    private static final int POS_SUBQUERY = 0;
    private static final int POS_FUNCTION_CALL_PACKAGE_NAME = 0;
    private static final int POS_FUNCTION_CALL_ROUTINE_NAME = 1;
    private static final int POS_FUNCTION_CALL_PACKAGE_NAME_SCHEMA_PART = 0;
    private static final int POS_FUNCTION_CALL_PACKAGE_NAME_PACKAGE_PART = 1;
    private static final int POS_FUNCTION_CALL_EXPS = 2;
    private static final int POS_EXTRACT_FIELD = 0;
    private static final int POS_EXTRACT_EXP = 1;
    private static final int POS_IN_PREDICATE_EXP = 0;
    private static final int POS_IN_PREDICATE_VALUES = 1;
    private static final int POS_IS_NULL_EXP = 0;
    private static final int POS_IF_ELSE_EXP1 = 0;
    private static final int POS_IF_ELSE_EXP2 = 1;
    private static final int POS_IF_ELSE_EXP3 = 2;
    private static final int POS_SIMPLE_CASE_OPERAND = 0;
    private static final int POS_SIMPLE_CASE_WHENTHEN_EXPS = 1;
    private static final int POS_SIMPLE_CASE_ELSE_EXP = 2;
    private static final int POS_SIMPLE_CASE_IFELSE_ALTERNATIVE_REPRESENTATION = 3;
    private static final int POS_WHENTHEN_WHEN = 0;
    private static final int POS_WHENTHEN_THEN = 1;
    private static final int POS_ELSE_EXP = 0;
    private static final int POS_SUBSTRING_EXP = 0;
    private static final int POS_SUBSTRING_START = 1;
    private static final int POS_SUBSTRING_LENGTH = 2;
    private static final int POS_LENGTH_EXP = 0;
    private static final int POS_INTERVAL_VALUE = 0;
    private static final int POS_INTERVAL_DATETIME_FIELD = 1;

    protected static String getString(IStrategoTerm t) {
        while (t.getType() != TermType.STRING) {
            t = t.getSubterm(0);
        }
        return ((IStrategoString)t).stringValue();
    }

    protected static int getInt(IStrategoTerm t) {
        while (t.getType() != TermType.INT) {
            t = t.getSubterm(0);
        }
        return ((IStrategoInt)t).intValue();
    }

    protected static IStrategoTerm getList(IStrategoTerm t) {
        while (t.getType() != TermType.LIST) {
            t = t.getSubterm(0);
        }
        return t;
    }

    protected static boolean isNone(IStrategoTerm t) {
        return t.getType() == TermType.APPL && ((IStrategoAppl)t).getConstructor().getName().equals("None");
    }

    protected static boolean isSome(IStrategoTerm t) {
        return t.getType() == TermType.APPL && ((IStrategoAppl)t).getConstructor().getName().equals("Some");
    }

    protected static IStrategoTerm getSomeValue(IStrategoTerm t) {
        return t.getSubterm(0);
    }

    protected static String getConstructorName(IStrategoTerm t) {
        return ((IStrategoAppl)t).getConstructor().getName();
    }

    protected static SchemaQualifiedName getSchemaQualifiedName(IStrategoTerm schemaQualifiedNameT) {
        IStrategoTerm schemaNameT = schemaQualifiedNameT.getSubterm(LOCAL_OR_SCHEMA_QUALIFIED_NAME_SCHEMA_NAME);
        String schemaName = null;
        if (CommonTranslationUtil.isSome(schemaNameT)) {
            schemaName = CommonTranslationUtil.getString(schemaNameT);
        }
        String localName = CommonTranslationUtil.getString(schemaQualifiedNameT.getSubterm(LOCAL_OR_SCHEMA_QUALIFIED_NAME_LOCAL_NAME));
        return new SchemaQualifiedName(schemaName, localName);
    }

    protected static QueryExpression translateExp(IStrategoTerm t, TranslationContext ctx) throws PgqlException {
        String cons;
        switch (cons = ((IStrategoAppl)t).getConstructor().getName()) {
            case "ExpressionPlusType": {
                return CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
            }
            case "Sub": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ArithmeticExpression.Sub(exp1, exp2);
            }
            case "Add": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ArithmeticExpression.Add(exp1, exp2);
            }
            case "Mul": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ArithmeticExpression.Mul(exp1, exp2);
            }
            case "Div": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ArithmeticExpression.Div(exp1, exp2);
            }
            case "Mod": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ArithmeticExpression.Mod(exp1, exp2);
            }
            case "UMin": {
                QueryExpression exp = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                return new QueryExpression.ArithmeticExpression.UMin(exp);
            }
            case "And": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.LogicalExpression.And(exp1, exp2);
            }
            case "Or": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.LogicalExpression.Or(exp1, exp2);
            }
            case "Not": {
                QueryExpression exp = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                return new QueryExpression.LogicalExpression.Not(exp);
            }
            case "Eq": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.Equal(exp1, exp2);
            }
            case "Neq": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.NotEqual(exp1, exp2);
            }
            case "Gt": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.Greater(exp1, exp2);
            }
            case "Gte": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.GreaterEqual(exp1, exp2);
            }
            case "Lt": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.Less(exp1, exp2);
            }
            case "Lte": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.RelationalExpression.LessEqual(exp1, exp2);
            }
            case "Cct": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                return new QueryExpression.ConcatExpression(exp1, exp2);
            }
            case "Integer": {
                long l = CommonTranslationUtil.parseLong(t);
                return new QueryExpression.Constant.ConstInteger(l);
            }
            case "Decimal": {
                double d = Double.parseDouble(CommonTranslationUtil.getString(t));
                return new QueryExpression.Constant.ConstDecimal(d);
            }
            case "String": 
            case "Identifier": {
                String s = CommonTranslationUtil.getString(t);
                return new QueryExpression.Constant.ConstString(s);
            }
            case "True": {
                return new QueryExpression.Constant.ConstBoolean(true);
            }
            case "False": {
                return new QueryExpression.Constant.ConstBoolean(false);
            }
            case "Date": {
                LocalDate date;
                String s = CommonTranslationUtil.getString(t);
                try {
                    date = LocalDate.parse(s, SqlDateTimeFormatter.SQL_DATE);
                }
                catch (DateTimeParseException e) {
                    date = LocalDate.MIN;
                }
                return new QueryExpression.Constant.ConstDate(date);
            }
            case "Time": {
                String s = CommonTranslationUtil.getString(t);
                try {
                    LocalTime time = LocalTime.parse(s, SqlDateTimeFormatter.SQL_TIME);
                    return new QueryExpression.Constant.ConstTime(time);
                }
                catch (DateTimeParseException e) {
                    try {
                        OffsetTime timeWithTimezone = OffsetTime.parse(s, SqlDateTimeFormatter.SQL_TIME_WITH_TIMEZONE);
                        return new QueryExpression.Constant.ConstTimeWithTimezone(timeWithTimezone);
                    }
                    catch (DateTimeParseException e2) {
                        return new QueryExpression.Constant.ConstTime(LocalTime.MIN);
                    }
                }
            }
            case "Timestamp": {
                String s = CommonTranslationUtil.getString(t);
                try {
                    LocalDateTime timestamp = LocalDateTime.parse(s, SqlDateTimeFormatter.SQL_TIMESTAMP);
                    return new QueryExpression.Constant.ConstTimestamp(timestamp);
                }
                catch (DateTimeParseException e) {
                    try {
                        OffsetDateTime timestampWithTimezone = OffsetDateTime.parse(s, SqlDateTimeFormatter.SQL_TIMESTAMP_WITH_TIMEZONE);
                        return new QueryExpression.Constant.ConstTimestampWithTimezone(timestampWithTimezone);
                    }
                    catch (DateTimeParseException e2) {
                        return new QueryExpression.Constant.ConstTimestamp(LocalDateTime.MIN);
                    }
                }
            }
            case "Interval": {
                String value = CommonTranslationUtil.getString(t.getSubterm(0));
                QueryExpression.DateTimeField dateTimeField = QueryExpression.DateTimeField.valueOf((String)CommonTranslationUtil.getString(t.getSubterm(1)));
                return new QueryExpression.Interval(value, dateTimeField);
            }
            case "VarRef": {
                QueryVariable var = CommonTranslationUtil.getVariable(ctx, t);
                return new QueryExpression.VarRef(var);
            }
            case "BindVariable": {
                int parameterIndex = CommonTranslationUtil.getInt(t);
                return new QueryExpression.BindVariable(parameterIndex);
            }
            case "PropRef": {
                IStrategoTerm varRefT = t.getSubterm(0);
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)CommonTranslationUtil.translateExp(varRefT, ctx);
                String propname = CommonTranslationUtil.getString(t.getSubterm(1));
                return new QueryExpression.PropertyAccess(varRef.getVariable(), propname);
            }
            case "Cast": {
                QueryExpression exp = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                String targetTypeName = CommonTranslationUtil.getString(t.getSubterm(1));
                return new QueryExpression.Function.Cast(exp, targetTypeName);
            }
            case "CharacterSubstring": {
                QueryExpression exp = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression startExp = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                IStrategoTerm lengthExpT = t.getSubterm(2);
                QueryExpression lengthExp = CommonTranslationUtil.isSome(lengthExpT) ? CommonTranslationUtil.translateExp(CommonTranslationUtil.getSomeValue(lengthExpT).getSubterm(0), ctx) : null;
                return new QueryExpression.SubstringExpression(exp, startExp, lengthExp);
            }
            case "BetweenPredicate": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                QueryExpression exp3 = CommonTranslationUtil.translateExp(t.getSubterm(2), ctx);
                return new QueryExpression.BetweenPredicate(exp1, exp2, exp3);
            }
            case "Exists": {
                IStrategoTerm subqueryT = t.getSubterm(0);
                SelectQuery selectQuery = CommonTranslationUtil.translateSubquery(ctx, subqueryT);
                return new QueryExpression.Function.Exists(selectQuery);
            }
            case "ScalarSubquery": {
                IStrategoTerm subqueryT = t.getSubterm(0);
                SelectQuery selectQuery = CommonTranslationUtil.translateSubquery(ctx, subqueryT);
                return new QueryExpression.ScalarSubquery(selectQuery);
            }
            case "CallStatement": 
            case "FunctionCall": {
                String schemaName = null;
                String packageName = null;
                IStrategoTerm optionalPackageDeclT = t.getSubterm(0);
                if (CommonTranslationUtil.isSome(optionalPackageDeclT)) {
                    IStrategoTerm packageDeclT = CommonTranslationUtil.getSomeValue(optionalPackageDeclT);
                    IStrategoTerm schemaT = packageDeclT.getSubterm(0);
                    if (CommonTranslationUtil.isSome(schemaT)) {
                        schemaName = CommonTranslationUtil.getString(schemaT);
                    }
                    packageName = CommonTranslationUtil.getString(packageDeclT.getSubterm(1));
                }
                String functionName = CommonTranslationUtil.getString(t.getSubterm(1));
                IStrategoTerm argsT = CommonTranslationUtil.getList(t.getSubterm(2));
                List<QueryExpression> args = CommonTranslationUtil.varArgsToExps(ctx, argsT);
                if (schemaName == null && packageName == null) {
                    switch (functionName) {
                        case "VERTEX_ID": 
                        case "EDGE_ID": {
                            return new QueryExpression.FunctionCall(null, null, "ID", args);
                        }
                        case "VERTEX_EQUAL": 
                        case "EDGE_EQUAL": {
                            return new QueryExpression.RelationalExpression.Equal(args.get(0), args.get(1));
                        }
                        case "MATCHNUM": {
                            return new QueryExpression.FunctionCall(null, null, "MATCH_NUMBER", args);
                        }
                    }
                }
                return new QueryExpression.FunctionCall(schemaName, packageName, functionName, args);
            }
            case "ExtractExp": {
                QueryExpression.ExtractExpression.ExtractField field;
                IStrategoAppl fieldT = (IStrategoAppl)t.getSubterm(0);
                switch (fieldT.getConstructor().getName()) {
                    case "Year": {
                        field = QueryExpression.ExtractExpression.ExtractField.YEAR;
                        break;
                    }
                    case "Month": {
                        field = QueryExpression.ExtractExpression.ExtractField.MONTH;
                        break;
                    }
                    case "Day": {
                        field = QueryExpression.ExtractExpression.ExtractField.DAY;
                        break;
                    }
                    case "Hour": {
                        field = QueryExpression.ExtractExpression.ExtractField.HOUR;
                        break;
                    }
                    case "Minute": {
                        field = QueryExpression.ExtractExpression.ExtractField.MINUTE;
                        break;
                    }
                    case "Second": {
                        field = QueryExpression.ExtractExpression.ExtractField.SECOND;
                        break;
                    }
                    case "TimezoneHour": {
                        field = QueryExpression.ExtractExpression.ExtractField.TIMEZONE_HOUR;
                        break;
                    }
                    case "TimezoneMinute": {
                        field = QueryExpression.ExtractExpression.ExtractField.TIMEZONE_MINUTE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                IStrategoTerm expT = t.getSubterm(1);
                QueryExpression exp = CommonTranslationUtil.translateExp(expT, ctx);
                return new QueryExpression.ExtractExpression(field, exp);
            }
            case "InPredicate": {
                IStrategoTerm expT = t.getSubterm(0);
                QueryExpression exp = CommonTranslationUtil.translateExp(expT, ctx);
                IStrategoTerm inValueListT = t.getSubterm(1);
                QueryExpression inValueList = CommonTranslationUtil.translateExp(inValueListT, ctx);
                return new QueryExpression.InPredicate(exp, inValueList);
            }
            case "IsNull": {
                IStrategoTerm expT = t.getSubterm(0);
                QueryExpression exp = CommonTranslationUtil.translateExp(expT, ctx);
                return new QueryExpression.IsNull(exp);
            }
            case "IfElse": {
                QueryExpression exp1 = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                QueryExpression exp2 = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                QueryExpression exp3 = CommonTranslationUtil.translateExp(t.getSubterm(2), ctx);
                return new QueryExpression.IfElse(exp1, exp2, exp3);
            }
            case "SimpleCase": {
                QueryExpression operandExp = CommonTranslationUtil.translateExp(t.getSubterm(0), ctx);
                ArrayList<QueryExpression.WhenThenExpression> whenThenExps = new ArrayList<QueryExpression.WhenThenExpression>();
                for (IStrategoTerm whenThen : t.getSubterm(1)) {
                    QueryExpression when = CommonTranslationUtil.translateExp(whenThen.getSubterm(0), ctx);
                    QueryExpression then = CommonTranslationUtil.translateExp(whenThen.getSubterm(1), ctx);
                    whenThenExps.add(new QueryExpression.WhenThenExpression(when, then));
                }
                QueryExpression elseExp = null;
                IStrategoTerm elseExpT = t.getSubterm(2);
                if (CommonTranslationUtil.isSome(elseExpT)) {
                    elseExp = CommonTranslationUtil.translateExp(CommonTranslationUtil.getSomeValue(elseExpT).getSubterm(0), ctx);
                }
                QueryExpression.IfElse ifElseAlterantiveRepresentation = (QueryExpression.IfElse)CommonTranslationUtil.translateExp(t.getSubterm(3), ctx);
                return new QueryExpression.SimpleCase(operandExp, whenThenExps, elseExp, ifElseAlterantiveRepresentation);
            }
            case "Null": 
            case "IllegalNull": {
                return null;
            }
            case "Array": {
                IStrategoTerm arrayValues = t.getSubterm(0);
                int size = arrayValues.getSubtermCount();
                long[] integerValues = new long[size];
                double[] decimalValues = new double[size];
                boolean[] booleanValues = new boolean[size];
                String[] stringValues = new String[size];
                LocalDate[] dateValues = new LocalDate[size];
                LocalTime[] timeValues = new LocalTime[size];
                LocalDateTime[] timestampValues = new LocalDateTime[size];
                QueryExpression.ExpressionType arrayElementType = null;
                block182: for (int i = 0; i < size; ++i) {
                    QueryExpression literal = CommonTranslationUtil.translateExp(arrayValues.getSubterm(i), ctx);
                    switch (literal.getExpType()) {
                        case INTEGER: {
                            long integerValue;
                            if (arrayElementType == null) {
                                arrayElementType = QueryExpression.ExpressionType.INTEGER;
                            }
                            integerValues[i] = integerValue = ((Long)((QueryExpression.Constant.ConstInteger)literal).getValue()).longValue();
                            decimalValues[i] = integerValue;
                            continue block182;
                        }
                        case DECIMAL: {
                            arrayElementType = QueryExpression.ExpressionType.DECIMAL;
                            decimalValues[i] = (Double)((QueryExpression.Constant.ConstDecimal)literal).getValue();
                            continue block182;
                        }
                        case BOOLEAN: {
                            arrayElementType = QueryExpression.ExpressionType.BOOLEAN;
                            booleanValues[i] = (Boolean)((QueryExpression.Constant.ConstBoolean)literal).getValue();
                            continue block182;
                        }
                        case STRING: {
                            arrayElementType = QueryExpression.ExpressionType.STRING;
                            stringValues[i] = (String)((QueryExpression.Constant.ConstString)literal).getValue();
                            continue block182;
                        }
                        case DATE: {
                            arrayElementType = QueryExpression.ExpressionType.DATE;
                            dateValues[i] = (LocalDate)((QueryExpression.Constant.ConstDate)literal).getValue();
                            continue block182;
                        }
                        case TIME: {
                            arrayElementType = QueryExpression.ExpressionType.TIME;
                            timeValues[i] = (LocalTime)((QueryExpression.Constant.ConstTime)literal).getValue();
                            continue block182;
                        }
                        case TIMESTAMP: {
                            arrayElementType = QueryExpression.ExpressionType.TIMESTAMP;
                            timestampValues[i] = (LocalDateTime)((QueryExpression.Constant.ConstTimestamp)literal).getValue();
                            continue block182;
                        }
                        case TIME_WITH_TIMEZONE: {
                            arrayElementType = QueryExpression.ExpressionType.TIME;
                            timeValues[i] = ((OffsetTime)((QueryExpression.Constant.ConstTimeWithTimezone)literal).getValue()).withOffsetSameInstant(ZoneOffset.UTC).toLocalTime();
                            continue block182;
                        }
                        case TIMESTAMP_WITH_TIMEZONE: {
                            arrayElementType = QueryExpression.ExpressionType.TIMESTAMP;
                            timestampValues[i] = ((OffsetDateTime)((QueryExpression.Constant.ConstTimestampWithTimezone)literal).getValue()).withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
                            continue block182;
                        }
                        default: {
                            arrayElementType = QueryExpression.ExpressionType.INTEGER;
                        }
                    }
                }
                switch (arrayElementType) {
                    case INTEGER: {
                        return new QueryExpression.InPredicate.InValueList(integerValues);
                    }
                    case DECIMAL: {
                        return new QueryExpression.InPredicate.InValueList(decimalValues);
                    }
                    case BOOLEAN: {
                        return new QueryExpression.InPredicate.InValueList(booleanValues);
                    }
                    case STRING: {
                        return new QueryExpression.InPredicate.InValueList(stringValues);
                    }
                    case DATE: {
                        return new QueryExpression.InPredicate.InValueList(dateValues);
                    }
                    case TIME: {
                        return new QueryExpression.InPredicate.InValueList(timeValues);
                    }
                    case TIMESTAMP: {
                        return new QueryExpression.InPredicate.InValueList(timestampValues);
                    }
                }
                throw new IllegalArgumentException(arrayElementType.toString());
            }
            case "COUNT": 
            case "MIN": 
            case "MAX": 
            case "SUM": 
            case "AVG": 
            case "ARRAY-AGG": 
            case "LISTAGG": {
                QueryExpression exp = CommonTranslationUtil.translateExp(t.getSubterm(1), ctx);
                boolean distinct = CommonTranslationUtil.aggregationHasDistinct(t);
                switch (cons) {
                    case "COUNT": {
                        return new QueryExpression.Aggregation.AggrCount(distinct, exp);
                    }
                    case "MIN": {
                        return new QueryExpression.Aggregation.AggrMin(distinct, exp);
                    }
                    case "MAX": {
                        return new QueryExpression.Aggregation.AggrMax(distinct, exp);
                    }
                    case "SUM": {
                        return new QueryExpression.Aggregation.AggrSum(distinct, exp);
                    }
                    case "AVG": {
                        return new QueryExpression.Aggregation.AggrAvg(distinct, exp);
                    }
                    case "ARRAY-AGG": {
                        return new QueryExpression.Aggregation.AggrArrayAgg(distinct, exp);
                    }
                    case "LISTAGG": {
                        String separator = "";
                        IStrategoTerm optionalSeparator = t.getSubterm(2);
                        if (CommonTranslationUtil.isSome(optionalSeparator)) {
                            IStrategoTerm separatorT = CommonTranslationUtil.getSomeValue(optionalSeparator);
                            separator = CommonTranslationUtil.getString(separatorT);
                        }
                        return new QueryExpression.Aggregation.AggrListagg(distinct, exp, separator);
                    }
                }
                throw new IllegalArgumentException(cons);
            }
            case "Star": {
                return new QueryExpression.Star();
            }
        }
        throw new UnsupportedOperationException("Expression unsupported: " + t);
    }

    private static SelectQuery translateSubquery(TranslationContext ctx, IStrategoTerm t) throws PgqlException {
        IStrategoTerm subqueryT = t.getSubterm(0);
        GraphQuery query = SpoofaxAstToGraphQuery.translate(subqueryT, ctx);
        if (query.getQueryType() == QueryType.SELECT) {
            return (SelectQuery)query;
        }
        return null;
    }

    private static boolean aggregationHasDistinct(IStrategoTerm t) {
        return CommonTranslationUtil.isSome(t.getSubterm(0));
    }

    protected static QueryVariable getVariable(TranslationContext ctx, IStrategoTerm varRefT) {
        String varName = CommonTranslationUtil.getString(varRefT.getSubterm(0));
        IStrategoTerm originOffset = null;
        if (varRefT.getSubtermCount() <= 1) {
            return new QueryVertex(varName, false);
        }
        originOffset = varRefT.getSubterm(1);
        return ctx.getVariable(originOffset);
    }

    protected static long parseLong(IStrategoTerm t) throws PgqlException {
        try {
            return Long.parseLong(CommonTranslationUtil.getString(t));
        }
        catch (NumberFormatException e) {
            throw new PgqlException(CommonTranslationUtil.getString(t) + " is too large to be stored as long");
        }
    }

    protected static int parseInt(IStrategoTerm t) throws PgqlException {
        try {
            return Integer.parseInt(CommonTranslationUtil.getString(t));
        }
        catch (NumberFormatException e) {
            throw new PgqlException(CommonTranslationUtil.getString(t) + " is too large to be stored as int");
        }
    }

    private static List<QueryExpression> varArgsToExps(TranslationContext ctx, IStrategoTerm expsT) throws PgqlException {
        ArrayList<QueryExpression> exps = new ArrayList<QueryExpression>();
        for (IStrategoTerm expT : expsT) {
            exps.add(CommonTranslationUtil.translateExp(expT, ctx));
        }
        return exps;
    }
}

