/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.logging.Level;
import javax.swing.JPanel;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;

public class ExplainPlanPanel
extends JPanel {
    private AutotracePanel m_explainPlanPanel;
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("ExplainPlanPanel");

    public ExplainPlanPanel() {
        this.setLayout(new BorderLayout());
    }

    public void showExplainPlan(Database database, String string) {
        String string2 = String.valueOf(System.currentTimeMillis());
        if (this.m_explainPlanPanel != null) {
            this.remove((Component)this.m_explainPlanPanel);
            this.m_explainPlanPanel = null;
        }
        try {
            Object object;
            if (database.getConnectionStore() == null) {
                this.m_explainPlanPanel = new AutotracePanel(null, true, "oracle.jdbc.OracleDriver");
            } else {
                object = new WorksheetContext();
                object.setConnectionName(database.getQualifiedName());
                this.m_explainPlanPanel = new AutotracePanel(null, true, object);
            }
            object = database.getConnection();
            this.m_explainPlanPanel.open();
            this.m_explainPlanPanel.explainPlan(string, string2, (Connection)object);
            this.m_explainPlanPanel.fetchPlan(string, string2, (Connection)object);
            this.m_explainPlanPanel.tbl.revalidate();
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (this.m_explainPlanPanel != null) {
            this.m_reshelp.setName((Component)this.m_explainPlanPanel, "AutotracePane");
            this.add((Component)this.m_explainPlanPanel, "Center");
        }
        this.repaint();
    }

    @Deprecated
    public void showExplainPlan(Connection connection, String string) {
    }
}

