/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.Bookmarks;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;

public abstract class URLBookmark
implements Bookmark {
    private static URLComparator comparator = new URLComparator();
    private URL url;
    private String description;

    public URLBookmark(URL url) {
        this.setURL(url);
        this.setDescription(Bookmarks.format("BOOKMARK_DESCRIPTION_FORMAT_URL", URLFileSystem.getFileName((URL)url)));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("URL: " + this.url.toString());
        buffer.append("\n");
        buffer.append("desc: " + this.description);
        buffer.append("\n");
        return buffer.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        assert (url != null);
        this.url = url;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int compareTo(Bookmark o) {
        if (o instanceof URLBookmark) {
            URLBookmark that = (URLBookmark)o;
            return comparator.compare((Object)this.getURL(), (Object)that.getURL());
        }
        return 0;
    }

    @Override
    public Bookmark.SortOrder compareTo(Context context) {
        if (context.getNode() == null || context.getNode().getURL() == null) {
            return Bookmark.SortOrder.UNKNOWN;
        }
        URL contextURL = context.getNode().getURL();
        int i = comparator.compare((Object)this.url, (Object)contextURL);
        if (i == 0) {
            return Bookmark.SortOrder.EQUAL;
        }
        if (i < 0) {
            return Bookmark.SortOrder.BEFORE;
        }
        return Bookmark.SortOrder.AFTER;
    }
}

