/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public final class SyntaxSchemes
implements Copyable {
    public static final String KEY_SETTINGS = "SyntaxSchemes";
    private HashMap schemeMap = new HashMap();

    public Object copyTo(Object target) {
        SyntaxSchemes copy = target != null ? (SyntaxSchemes)target : new SyntaxSchemes();
        ModelUtil.deepCopy((Map)this.schemeMap, (Map)copy.schemeMap);
        return copy;
    }

    public HashMap getSchemeMap() {
        return this.schemeMap;
    }

    public void setSchemeMap(HashMap newMap) {
        this.schemeMap = newMap;
    }

    public String[] getSchemeNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        Set keySet = this.schemeMap.keySet();
        for (String schemeName : keySet) {
            nameList.add(schemeName);
        }
        int numNames = nameList.size();
        String[] namesArray = nameList.toArray(new String[numNames]);
        return namesArray;
    }

    public List getScheme(String schemeName) {
        return (List)this.schemeMap.get(schemeName);
    }

    public void removeScheme(String schemeName) {
        this.schemeMap.remove(schemeName);
    }

    public void putScheme(String schemeName, List styleList) {
        if (styleList == null || schemeName == null || schemeName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.schemeMap.put(schemeName, styleList);
    }
}

