/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class CaretOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "CaretOptions";
    private static final String ENABLE_BLINK = "enableBlink";
    private static final int MINIMUM_RATE = 100;
    private static final int MAXIMUM_RATE = 2000;
    private static final String BLINK_RATE = "blinkRate";
    private static final String INSERT_SHAPE = "insertShape";
    private static final String OVERWRITE_SHAPE = "overwriteShape";
    private static final String CARET_COLOR = "caretColor";
    private static final String RIGHT_CLICK_SELECTION = "rightClickSelection";

    public CaretOptions() {
        this(HashStructure.newInstance());
    }

    private CaretOptions(HashStructure hash) {
        super(hash);
    }

    public static CaretOptions getInstance(PropertyStorage prefs) {
        return new CaretOptions(CaretOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean getEnableBlink() {
        return this._hash.getBoolean(ENABLE_BLINK, true);
    }

    public void setEnableBlink(boolean enableBlink) {
        this._hash.putBoolean(ENABLE_BLINK, enableBlink);
    }

    public int getBlinkRate() {
        return this._hash.getInt(BLINK_RATE, 500);
    }

    public void setBlinkRate(int blinkRate) {
        this._hash.putInt(BLINK_RATE, Math.min(Math.max(blinkRate, 100), 2000));
    }

    public int getInsertShape() {
        return this._hash.getInt(INSERT_SHAPE, 2);
    }

    public void setInsertShape(int insertShape) {
        this._hash.putInt(INSERT_SHAPE, insertShape);
    }

    public int getOverwriteShape() {
        return this._hash.getInt(OVERWRITE_SHAPE, 6);
    }

    public void setOverwriteShape(int overwriteShape) {
        this._hash.putInt(OVERWRITE_SHAPE, overwriteShape);
    }

    public int getCaretColor() {
        return this._hash.getInt(CARET_COLOR, Color.black.getRGB());
    }

    public void setCaretColor(int caretColor) {
        this._hash.putInt(CARET_COLOR, caretColor);
    }

    public boolean getRightClickSelection() {
        return this._hash.getBoolean(RIGHT_CLICK_SELECTION, true);
    }

    public void setRightClickSelection(boolean rightClickSelection) {
        this._hash.putBoolean(RIGHT_CLICK_SELECTION, rightClickSelection);
    }
}

