/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.IdeKeymapHelper;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.StandaloneKeymapHelper;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.javatools.editor.keys.MultiKeymap;

public final class KeymapManager
implements ChangeListener {
    public static final String ACCEL_FILE = "oracle/ide/ceditor/keymap/accelerators.xml";
    private static KeymapManager singleton = new KeymapManager();
    private EditorKeyStrokes editorContext;
    private List helperList = new ArrayList();
    private MultiKeymap ideKeymap = null;
    private MultiKeymap standaloneKeymap = null;
    private HashMap ideActionMap = null;

    public static KeymapManager getInstance() {
        return singleton;
    }

    private KeymapManager() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        this.editorContext = new EditorKeyStrokes();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCEL_FILE);
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions options = ideSettings.getKeyStrokeOptions();
        options.addChangeListener((ChangeListener)this);
    }

    public EditorKeyStrokes getEditorKeyStrokes() {
        return this.editorContext;
    }

    synchronized KeymapHelper createIdeKeymapHelper(KeyStrokeContext[] keystrokeContexts) {
        IdeKeymapHelper keymapHelper = new IdeKeymapHelper(keystrokeContexts);
        WeakReference reference = keymapHelper.getWeakReference();
        this.helperList.add(reference);
        return keymapHelper;
    }

    synchronized KeymapHelper createStandaloneKeymapHelper(KeyStrokeContext[] keystrokeContexts) {
        StandaloneKeymapHelper keymapHelper = new StandaloneKeymapHelper(keystrokeContexts);
        WeakReference reference = keymapHelper.getWeakReference();
        this.helperList.add(reference);
        return keymapHelper;
    }

    synchronized MultiKeymap getIdeKeymap() {
        if (this.ideKeymap == null) {
            this.buildIdeMaps();
        }
        return this.ideKeymap;
    }

    synchronized MultiKeymap getStandaloneKeymap() {
        if (this.standaloneKeymap == null) {
            this.buildStandaloneMaps();
        }
        return this.standaloneKeymap;
    }

    synchronized Map getIdeActionMap() {
        if (this.ideActionMap == null) {
            this.buildIdeMaps();
        }
        return this.ideActionMap;
    }

    synchronized void buildExtendedMaps(KeyStrokeContext[] keystrokeContexts, MultiKeymap[] extendedKeymap_out, Map[] extendedActionmap_out) {
        MultiKeymap extendedKeymap = new MultiKeymap();
        HashMap<String, IdeAction> extendedActionMap = new HashMap<String, IdeAction>();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions options = ideSettings.getKeyStrokeOptions();
        for (KeyStrokeContext keystrokeContext : keystrokeContexts) {
            Set localKeySet;
            if (keystrokeContext == null) continue;
            KeyStrokeMap localKeymap = options.getLocalKeyMap(keystrokeContext);
            Set localActions = keystrokeContext.getAllActions(false);
            Set set = localKeySet = localKeymap != null ? localKeymap.keySet() : null;
            if (localKeySet == null) continue;
            for (KeyStrokes keystrokes : localKeySet) {
                Integer binding = localKeymap.getBindingFor(keystrokes);
                int commandId = binding;
                IdeAction action = IdeAction.find((int)commandId);
                if (action == null) continue;
                String pseudoName = "*LOCAL*" + commandId;
                extendedActionMap.put(pseudoName, action);
                KeyStroke[] keys = this.splitKeyStrokes(keystrokes);
                try {
                    extendedKeymap.put(keys, keys.length, pseudoName);
                }
                catch (RuntimeException e) {
                    System.out.println("Keymap exception: " + e.toString());
                }
            }
        }
        extendedKeymap_out[0] = extendedKeymap;
        extendedActionmap_out[0] = extendedActionMap;
    }

    private synchronized void buildIdeMaps() {
        KeyStrokeMap ideMap;
        Set ideKeySet;
        Set editorKeySet;
        this.ideKeymap = new MultiKeymap();
        this.ideActionMap = new HashMap();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions options = ideSettings.getKeyStrokeOptions();
        Set editorActions = this.editorContext.getAllActions(false);
        KeyStrokeMap editorMap = KeymapManager.getKeyStrokeMap();
        Set set = editorKeySet = editorMap != null ? editorMap.keySet() : null;
        if (editorKeySet != null) {
            block11: for (KeyStrokes keystrokes : editorKeySet) {
                Integer binding = editorMap.getBindingFor(keystrokes);
                int commandId = binding;
                for (IdeAction action : editorActions) {
                    int actionId = action.getCommandId();
                    if (actionId != commandId) continue;
                    String name = action.getCommand();
                    if (name == null) {
                        name = Ide.findCmdName((int)commandId);
                    }
                    KeyStroke[] keys = this.splitKeyStrokes(keystrokes);
                    try {
                        this.ideKeymap.put(keys, keys.length, name);
                    }
                    catch (RuntimeException e) {
                        System.out.println("Keymap exception: " + e.toString());
                    }
                    continue block11;
                }
            }
        }
        Set set2 = ideKeySet = (ideMap = options.getGlobalKeyMap()) != null ? ideMap.keySet() : null;
        if (ideKeySet != null) {
            for (KeyStrokes keystrokes : ideKeySet) {
                String pseudoName;
                Integer binding = ideMap.getBindingFor(keystrokes);
                int commandId = binding;
                IdeAction action = IdeAction.find((int)commandId);
                if (action == null) continue;
                Object pseudoNameProperty = action.getValue("editor-pseudo-name");
                if (pseudoNameProperty instanceof String) {
                    pseudoName = (String)pseudoNameProperty;
                    this.ideActionMap.put(pseudoName, action);
                } else {
                    switch (commandId) {
                        case 17: {
                            pseudoName = "cut-to-clipboard";
                            break;
                        }
                        case 18: {
                            pseudoName = "copy-to-clipboard";
                            break;
                        }
                        case 19: {
                            pseudoName = "paste-from-clipboard";
                            break;
                        }
                        case 22: {
                            pseudoName = "select-all";
                            break;
                        }
                        case 20: {
                            pseudoName = "delete-next";
                            break;
                        }
                        default: {
                            pseudoName = "*IDE*" + commandId;
                            this.ideActionMap.put(pseudoName, action);
                        }
                    }
                }
                KeyStroke[] keys = this.splitKeyStrokes(keystrokes);
                try {
                    this.ideKeymap.put(keys, keys.length, pseudoName);
                }
                catch (RuntimeException e) {
                    System.out.println("Keymap exception: " + e.toString());
                }
            }
        }
    }

    private static KeyStrokeMap getKeyStrokeMap() {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(ACCEL_FILE);
        KeyStrokeOptions options = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap editorMap = options.getLocalKeyMap(keyStrokeContext);
        return editorMap;
    }

    private synchronized void buildStandaloneMaps() {
        KeyStrokeMap ideMap;
        Set ideKeySet;
        KeyStroke[] keys;
        Set editorKeySet;
        this.standaloneKeymap = new MultiKeymap();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(ACCEL_FILE);
        KeyStrokeOptions options = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap editorMap = options.getLocalKeyMap(keyStrokeContext);
        Set editorActions = this.editorContext.getAllActions(false);
        Set set = editorKeySet = editorMap != null ? editorMap.keySet() : null;
        if (editorKeySet != null) {
            block11: for (KeyStrokes keystrokes : editorKeySet) {
                Integer binding = editorMap.getBindingFor(keystrokes);
                int commandId = binding;
                for (IdeAction action : editorActions) {
                    int actionId = action.getCommandId();
                    if (actionId != commandId) continue;
                    String name = action.getCommand();
                    if (name == null) {
                        name = Ide.findCmdName((int)commandId);
                    }
                    keys = this.splitKeyStrokes(keystrokes);
                    try {
                        this.standaloneKeymap.put(keys, keys.length, name);
                    }
                    catch (RuntimeException e) {
                        System.out.println("Keymap exception: " + e.toString());
                    }
                    continue block11;
                }
            }
        }
        Set set2 = ideKeySet = (ideMap = options.getGlobalKeyMap()) != null ? ideMap.keySet() : null;
        if (ideKeySet != null) {
            block13: for (KeyStrokes keystrokes : ideKeySet) {
                String pseudoName;
                Integer binding = ideMap.getBindingFor(keystrokes);
                int commandId = binding;
                IdeAction action = IdeAction.find((int)commandId);
                if (action == null) continue;
                switch (commandId) {
                    case 17: {
                        pseudoName = "cut-to-clipboard";
                        break;
                    }
                    case 18: {
                        pseudoName = "copy-to-clipboard";
                        break;
                    }
                    case 19: {
                        pseudoName = "paste-from-clipboard";
                        break;
                    }
                    case 22: {
                        pseudoName = "select-all";
                        break;
                    }
                    case 20: {
                        pseudoName = "delete-next";
                        break;
                    }
                    default: {
                        continue block13;
                    }
                }
                keys = this.splitKeyStrokes(keystrokes);
                try {
                    this.standaloneKeymap.put(keys, keys.length, pseudoName);
                }
                catch (RuntimeException e) {
                    System.out.println("Keymap exception: " + e.toString());
                }
            }
        }
    }

    private KeyStroke[] splitKeyStrokes(KeyStrokes keystrokes) {
        int numKeys = keystrokes.getLength();
        KeyStroke[] keys = new KeyStroke[numKeys];
        for (int j = 0; j < numKeys; ++j) {
            keys[j] = keystrokes.getKeyStroke(j);
        }
        return keys;
    }

    @Override
    public synchronized void stateChanged(ChangeEvent event) {
        this.ideKeymap = null;
        this.standaloneKeymap = null;
        this.ideActionMap = null;
        Iterator iterator = this.helperList.iterator();
        while (iterator.hasNext()) {
            WeakReference reference = (WeakReference)iterator.next();
            if (reference == null || reference.get() == null) {
                iterator.remove();
                continue;
            }
            KeymapHelper keymapHelper = (KeymapHelper)reference.get();
            if (keymapHelper == null) continue;
            keymapHelper.keymapChanged();
        }
    }
}

