/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.controller.IdeAction;
import oracle.javatools.editor.ActionNames;

public final class EditorKeyStrokes {
    private static final String EDITOR_CATEGORY = CEditorArb.getString(4);
    private HashMap actionMap;

    public EditorKeyStrokes() {
        this.initialize();
    }

    private void initialize() {
        if (this.actionMap == null) {
            String[] actionNames = ActionNames.getAllActionNames();
            this.actionMap = new HashMap();
            for (String name : actionNames) {
                if (name.equals("cut-to-clipboard") || name.equals("copy-to-clipboard") || name.equals("paste-from-clipboard") || name.equals("select-all") || name.equals("delete-next")) continue;
                IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)name), (String)name, (String)ActionNames.lookupTranslatedName((String)name), (String)EDITOR_CATEGORY, null, null, null, (boolean)false);
                this.actionMap.put(name, action);
            }
        }
    }

    public Set getAllActions(boolean bGlobal) {
        if (!bGlobal) {
            Collection mapValues = this.actionMap.values();
            return new HashSet(mapValues);
        }
        return null;
    }

    public IdeAction lookupAction(String actionName) {
        return (IdeAction)this.actionMap.get(actionName);
    }
}

