/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class InsightCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final int GAP = 36;
    private String description = "";

    protected void setDescription(String description) {
        this.description = description;
    }

    protected String getDescription() {
        return this.description;
    }

    public InsightCellRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(this.getText());
        Insets i = this.getInsets();
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        FontMetrics fm = list.getFontMetrics(list.getFont());
        int width = SwingUtilities.computeStringWidth(fm, this.getText());
        if (this.getDescription() != null) {
            width += 36 + SwingUtilities.computeStringWidth(fm, this.getDescription());
        }
        if (this.getIcon() != null) {
            width += this.getIconTextGap() + this.getIcon().getIconWidth();
        }
        this.setPreferredSize(new Dimension(width + i.left + i.right, fm.getHeight() + i.top + i.bottom));
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets i = this.getInsets();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getForeground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int y = g.getFontMetrics().getAscent() + i.top;
        Icon icon = this.getIcon();
        if (this.getIcon() == null) {
            g2.drawString(this.getText(), i.left, y);
        } else {
            icon.paintIcon(this, g2, i.left, i.top);
            g2.drawString(this.getText(), i.left + icon.getIconWidth() + this.getIconTextGap(), y);
        }
        String description = this.getDescription();
        if (description != null && description.length() > 0) {
            int descWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.getDescription());
            g2.drawString(this.getDescription(), this.getWidth() - descWidth - i.right, y);
        }
        g2.dispose();
    }
}

