/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;

public class LineNavigationPoint
extends CodeNavigationPoint {
    protected boolean hilight;
    protected boolean translate;

    public LineNavigationPoint(Context context, int line, int col, boolean select) {
        this.setContext(context);
        this.start = line;
        this.selLength = col;
        this.hilight = select;
    }

    public LineNavigationPoint(Context context, int offset, boolean select) {
        this.setContext(context);
        this.start = offset;
        this.translate = true;
        this.hilight = select;
    }

    private LineNavigationPoint() {
    }

    @Override
    public Object copyTo(Object target) {
        LineNavigationPoint point = target != null ? (LineNavigationPoint)((Object)target) : new LineNavigationPoint();
        this.copyToImpl(point);
        return point;
    }

    protected final void copyToImpl(LineNavigationPoint point) {
        super.copyToImpl(point);
        point.hilight = this.hilight;
        point.translate = this.translate;
    }

    protected int navigateImpl() throws Exception {
        Editor editor = this.findOrCreateEditor(true);
        if (editor == null) {
            return 1;
        }
        if (editor instanceof CodeEditor) {
            CodeEditor ceditor = (CodeEditor)editor;
            if (this.start < 0) {
                this.start = ceditor.getLineFromOffset(-this.start);
                this.selLength = 0;
            }
            if (this.translate) {
                this.selLength = this.start;
                this.start = ceditor.getLineFromOffset(this.start);
                this.selLength -= ceditor.getLineStartOffset(this.start);
            }
            ceditor.gotoLine(this.start, this.selLength, this.hilight);
        }
        return super.navigateImpl();
    }
}

