/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class DropHandlerPlugin
implements EditorPlugin {
    private BasicEditorPane editor;
    private static String HANDLER_PROPERTY = "*DHPRegisterList*";

    public final void install(BasicEditorPane editor) {
        this.editor = editor;
        DropHandlerPlugin.registerHandler(this, editor);
    }

    public void deinstall(BasicEditorPane editor) {
        DropHandlerPlugin.unregisterHandler(this, this.editor);
        this.editor = null;
    }

    protected final BasicEditorPane getEditorPane() {
        return this.editor;
    }

    protected final BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    static synchronized void registerHandler(DropHandlerPlugin handler, BasicEditorPane editorPane) {
        ArrayList<DropHandlerPlugin> handlerList = (ArrayList<DropHandlerPlugin>)editorPane.getProperty(HANDLER_PROPERTY);
        if (handlerList == null) {
            handlerList = new ArrayList<DropHandlerPlugin>(5);
            editorPane.putProperty(HANDLER_PROPERTY, handlerList);
        }
        if (!handlerList.contains(handler)) {
            handlerList.add(handler);
        }
    }

    static synchronized void unregisterHandler(DropHandlerPlugin handler, BasicEditorPane editorPane) {
        List handlerList = (List)editorPane.getProperty(HANDLER_PROPERTY);
        if (handlerList != null) {
            handlerList.remove(handler);
        }
    }

    static synchronized DropHandlerPlugin[] getHandlers(BasicEditorPane editorPane) {
        List handlerList = (List)editorPane.getProperty(HANDLER_PROPERTY);
        if (handlerList != null) {
            int numHandlers = handlerList.size();
            return handlerList.toArray(new DropHandlerPlugin[numHandlers]);
        }
        return new DropHandlerPlugin[0];
    }

    protected final void raiseEditorToFront() {
        Window parentWindow = SwingUtilities.getWindowAncestor((Component)this.editor);
        if (parentWindow != null) {
            parentWindow.toFront();
        }
        this.editor.requestFocus();
    }

    protected abstract int shouldAllowDrag(DropTargetDragEvent var1);

    protected abstract int shouldAllowDrop(DropTargetDropEvent var1);

    protected void cancelDragEvent(DropTargetEvent event) {
    }

    protected Point getDropLocationToPaint(DropTargetDragEvent event) {
        return event.getLocation();
    }

    protected abstract boolean performDrop(DropTargetDropEvent var1);
}

