/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.gradual.Coercion;
import org.strategoxt.lang.gradual.IdCoercion;
import org.strategoxt.lang.gradual.StrategoSCastException;
import org.strategoxt.lang.gradual.TypeInfo;

public class FunTCoercion {
    public static final FunTCoercion ID = new FunTCoercion(Collections.emptyList(), Collections.emptyList(), IdCoercion.INSTANCE, IdCoercion.INSTANCE);
    public final List<FunTCoercion> sargCoercions;
    public final List<Coercion> targCoercions;
    public final Coercion inputCoercion;
    public final Coercion outputCoercion;

    public FunTCoercion(List<FunTCoercion> sargCoercions, List<Coercion> targCoercions, Coercion inputCoercion, Coercion outputCoercion) {
        this.sargCoercions = sargCoercions;
        this.targCoercions = targCoercions;
        this.inputCoercion = inputCoercion;
        this.outputCoercion = outputCoercion;
    }

    public FunTCoercion wrapWith(Context context, FunTCoercion coercion) throws StrategoSCastException {
        if (this.sargCoercions.size() != coercion.sargCoercions.size() || this.targCoercions.size() != coercion.targCoercions.size()) {
            throw new StrategoSCastException(this, coercion);
        }
        TypeInfo typeInfo = context.typeInfo;
        ArrayList<FunTCoercion> newSargCoercions = new ArrayList<FunTCoercion>(this.sargCoercions.size());
        int i = 0;
        while (i < this.sargCoercions.size()) {
            newSargCoercions.add(this.sargCoercions.get(i).wrapWith(context, coercion.sargCoercions.get(i)));
            ++i;
        }
        ArrayList<Coercion> newTargCoercions = new ArrayList<Coercion>(this.targCoercions.size());
        int i2 = 0;
        while (i2 < this.targCoercions.size()) {
            newTargCoercions.add(this.targCoercions.get(i2).preCompose(typeInfo, coercion.targCoercions.get(i2)));
            ++i2;
        }
        Coercion newInputCoercion = this.inputCoercion.preCompose(typeInfo, coercion.inputCoercion);
        Coercion newOutputCoercion = coercion.outputCoercion.preCompose(typeInfo, this.outputCoercion);
        return new FunTCoercion(newSargCoercions, newTargCoercions, newInputCoercion, newOutputCoercion);
    }

    public String toString() {
        return "([" + this.sargCoercions + "], [" + this.targCoercions + "], " + this.inputCoercion + ", " + this.outputCoercion + ")";
    }
}

