/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.regex.Pattern;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.VarScope;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.InteropRegisterer;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.Strategy;

public class JavaInteropRegisterer
extends InteropRegisterer {
    private static final Pattern BINARY_STRATEGY_NAME = Pattern.compile("[A-Za-z0-9_$]+_[0-9]+_[0-9+]");
    private final Strategy[] strategies;

    public JavaInteropRegisterer(Strategy ... strategies) {
        if (strategies == null) {
            throw new IllegalArgumentException("strategies");
        }
        if (!this.getClass().getSimpleName().equals("InteropRegisterer")) {
            throw new IllegalStateException("Class must be named InteropRegisterer: " + this.getClass().getName());
        }
        this.strategies = strategies;
    }

    @Override
    public void register(IContext context, Context compiledContext) {
        VarScope registered = context.getVarScope();
        Strategy[] strategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            Strategy strategy = strategyArray[n2];
            String className = strategy.getClass().getSimpleName();
            String givenName = strategy.getName();
            if (!BINARY_STRATEGY_NAME.matcher(className).matches()) {
                throw new IllegalArgumentException("Strategy class must encode number of strategy and term arguments in name (e.g. foo_0_0): " + className);
            }
            if (!BINARY_STRATEGY_NAME.matcher(givenName).matches()) {
                throw new IllegalArgumentException("Strategy name must encode number of strategy and term arguments in name (e.g. foo_0_0): " + givenName);
            }
            registered.addSVar(givenName, new InteropSDefT(strategy, context));
            ++n2;
        }
    }

    @Override
    public void registerLazy(IContext context, Context compiledContext, ClassLoader classLoader) {
        this.register(context, compiledContext);
    }
}

