/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.util.Assert;

public class M {
    public static IStrategoAppl appl(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoAppl.class);
        return (IStrategoAppl)term;
    }

    public static IStrategoAppl appl(IStrategoTerm term, int arity) {
        IStrategoAppl appl = M.appl(term);
        Assert.assertEquals(arity, appl.getSubtermCount());
        return appl;
    }

    public static IStrategoAppl appl(IStrategoTerm term, String cons, int arity) {
        IStrategoAppl appl = M.appl(term, arity);
        Assert.assertEquals(cons, appl.getName());
        return appl;
    }

    public static IStrategoTuple tuple(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoTuple.class);
        return (IStrategoTuple)term;
    }

    public static IStrategoTuple tuple(IStrategoTerm term, int arity) {
        IStrategoTuple tuple = M.tuple(term);
        Assert.assertEquals(arity, tuple.getSubtermCount());
        return tuple;
    }

    public static IStrategoList list(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoList.class);
        return (IStrategoList)term;
    }

    public static String string(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoString.class);
        return ((IStrategoString)term).stringValue();
    }

    public static int integer(IStrategoTerm term) {
        Assert.assertInstanceOf(term, IStrategoInt.class);
        return ((IStrategoInt)term).intValue();
    }

    public static IStrategoTerm at(IStrategoAppl appl, int n) {
        return appl.getSubterm(n);
    }

    public static IStrategoTerm at(IStrategoTuple tuple, int n) {
        return tuple.getSubterm(n);
    }

    public static IStrategoTerm at(IStrategoList list, int n) {
        return list.getSubterm(n);
    }

    public static <R> Optional<R> maybe(Supplier<R> matcher) {
        R result;
        try {
            result = matcher.get();
        }
        catch (AssertionError | ClassCastException e) {
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

