/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.messages;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spoofax.jsglr2.messages.Category;
import org.spoofax.jsglr2.messages.Severity;
import org.spoofax.jsglr2.messages.SourceRegion;
import org.spoofax.jsglr2.parser.Position;

public class Message {
    public final String message;
    public final Category category;
    public final Severity severity;
    public final SourceRegion region;

    public Message(@Nonnull String message, @Nonnull Category category, @Nullable SourceRegion region) {
        this.message = message;
        this.category = category;
        this.severity = category.severity;
        this.region = region;
    }

    public Message(@Nonnull String message, @Nonnull Category category, @Nonnull Position startPosition, @Nonnull Position endPosition) {
        this(message, category, new SourceRegion(startPosition, endPosition));
    }

    public Message(@Nonnull String message, @Nonnull Category category, @Nullable Position position) {
        this(message, category, position == null ? null : new SourceRegion(position, position));
    }

    public Message atRegion(SourceRegion otherRegion) {
        return new Message(this.message, this.category, otherRegion);
    }

    public Message atPosition(Position position) {
        return new Message(this.message, this.category, position);
    }

    public String toString() {
        return "\"" + this.message + "\" " + (Object)((Object)this.severity) + " @ " + this.region;
    }
}

