/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder.treefactory;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.metaborg.parsetable.symbols.IMetaVarSymbol;
import org.metaborg.parsetable.symbols.ISymbol;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr2.imploder.treefactory.ITokenizedTreeFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.TermFactory;

public class TokenizedTermTreeFactory
implements ITokenizedTreeFactory<IStrategoTerm> {
    private final ITermFactory termFactory = new TermFactory();

    @Override
    public IStrategoTerm createCharacterTerminal(int character, IToken token) {
        IStrategoInt characterTerminalTerm = this.termFactory.makeInt(character);
        TokenizedTermTreeFactory.configure(characterTerminalTerm, null, token, token);
        return characterTerminalTerm;
    }

    @Override
    public IStrategoTerm createStringTerminal(ISymbol symbol, String value, IToken token) {
        IStrategoString stringTerminalTerm = this.termFactory.makeString(value);
        TokenizedTermTreeFactory.configure(stringTerminalTerm, ISymbol.getSort(symbol), token, token);
        return stringTerminalTerm;
    }

    @Override
    public IStrategoTerm createMetaVar(IMetaVarSymbol symbol, String value, IToken token) {
        IStrategoString stringTerm = this.termFactory.makeString(value);
        IStrategoAppl metaVarTerm = this.termFactory.makeAppl(symbol.metaVarCardinality().constructor, stringTerm);
        TokenizedTermTreeFactory.configure(stringTerm, ISymbol.getSort(symbol), token, token);
        TokenizedTermTreeFactory.configure(metaVarTerm, null, token, token);
        return metaVarTerm;
    }

    @Override
    public IStrategoTerm createNonTerminal(ISymbol symbol, String constructor, List<IStrategoTerm> childASTs, IToken leftToken, IToken rightToken) {
        IStrategoConstructor constructorTerm = this.termFactory.makeConstructor(constructor != null ? constructor : ISymbol.getSort(symbol), childASTs.size());
        IStrategoAppl nonTerminalTerm = this.termFactory.makeAppl(constructorTerm, TokenizedTermTreeFactory.toArray(childASTs));
        TokenizedTermTreeFactory.configure(nonTerminalTerm, ISymbol.getSort(symbol), leftToken, rightToken);
        return nonTerminalTerm;
    }

    @Override
    public IStrategoTerm createList(List<IStrategoTerm> children, IToken leftToken, IToken rightToken) {
        IStrategoList listTerm = this.termFactory.makeList(TokenizedTermTreeFactory.toArray(children));
        TokenizedTermTreeFactory.configure(listTerm, null, leftToken, rightToken);
        return listTerm;
    }

    @Override
    public IStrategoTerm createOptional(ISymbol symbol, List<IStrategoTerm> children, IToken leftToken, IToken rightToken) {
        String constructor = children == null || children.isEmpty() ? "None" : "Some";
        return this.createNonTerminal(symbol, constructor, (List)children, leftToken, rightToken);
    }

    @Override
    public IStrategoTerm createTuple(List<IStrategoTerm> children, IToken leftToken, IToken rightToken) {
        IStrategoTuple tupleTerm = this.termFactory.makeTuple(TokenizedTermTreeFactory.toArray(children));
        TokenizedTermTreeFactory.configure(tupleTerm, null, leftToken, rightToken);
        return tupleTerm;
    }

    @Override
    public IStrategoTerm createAmb(List<IStrategoTerm> alternatives, IToken leftToken, IToken rightToken) {
        Object alternativesListTerm = this.createList((List)alternatives, leftToken, rightToken);
        return this.createNonTerminal((ISymbol)null, "amb", Collections.singletonList(alternativesListTerm), leftToken, rightToken);
    }

    @Override
    public IStrategoTerm createInjection(ISymbol symbol, IStrategoTerm injected, boolean isBracket) {
        TokenizedTermTreeFactory.configureInjection(symbol, injected, isBracket);
        return injected;
    }

    private static IStrategoTerm[] toArray(List<IStrategoTerm> children) {
        return children.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY);
    }

    public static void configureInjection(ISymbol symbol, IStrategoTerm injected, boolean isBracket) {
        String sort = ISymbol.getSort(symbol);
        String injectedSort = ImploderAttachment.get(injected).getSort();
        if (sort != null && !Objects.equals(sort, injectedSort)) {
            ImploderAttachment.get(injected).pushInjection(sort);
        }
        ImploderAttachment.get(injected).setBracket(isBracket);
    }

    public static void configure(IStrategoTerm term, String sort, IToken leftToken, IToken rightToken) {
        rightToken = rightToken != null ? rightToken : leftToken;
        ImploderAttachment.putImploderAttachment(term, false, sort, leftToken, rightToken, false, false, false, false);
        if (term.getType() == TermType.LIST) {
            IStrategoList sublist = (IStrategoList)term;
            while (!sublist.isEmpty()) {
                IToken lastRightToken = ImploderAttachment.getRightToken(sublist.head());
                leftToken = (sublist = sublist.tail()).isEmpty() ? lastRightToken : ImploderAttachment.getLeftToken(sublist.head());
                ImploderAttachment.putImploderAttachment(sublist, false, sort, leftToken, rightToken, false, false, false, false);
            }
        }
    }
}

