/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.time;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class AggregateTimer {
    private final ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
    private final boolean canLogCPUTime = this.mxBean.isThreadCpuTimeSupported();
    private long startTime = -1L;
    private long totalTime = 0L;

    public AggregateTimer() {
        this(false);
    }

    public AggregateTimer(boolean start) {
        if (this.canLogCPUTime) {
            this.mxBean.setThreadCpuTimeEnabled(true);
        }
        if (start) {
            this.start();
        }
    }

    public void start() {
        if (this.startTime != -1L) {
            throw new IllegalStateException("Timer already started.");
        }
        this.startTime = this.time();
    }

    public long stop() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Timer not started.");
        }
        long dt = this.time() - this.startTime;
        this.startTime = -1L;
        this.totalTime += dt;
        return dt;
    }

    public long total() {
        return this.totalTime;
    }

    public void reset() {
        this.startTime = -1L;
        this.totalTime = 0L;
    }

    private long time() {
        if (this.canLogCPUTime) {
            return this.mxBean.getCurrentThreadCpuTime();
        }
        return System.nanoTime();
    }
}

