/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.task;

import org.metaborg.util.task.ICancel;

public class RateLimitedCancel
implements ICancel {
    private final ICancel cancel;
    private final int rate;
    private int n = 0;

    public RateLimitedCancel(ICancel cancel, int rate) {
        this.cancel = cancel;
        this.rate = rate;
    }

    @Override
    public boolean cancelled() {
        return this.n++ % this.rate == 0 ? this.cancel.cancelled() : false;
    }

    @Override
    public void throwIfCancelled() throws InterruptedException {
        if (this.n++ % this.rate == 0) {
            this.cancel.throwIfCancelled();
        }
    }

    @Override
    public void cancel() {
        this.cancel.cancel();
    }
}

