/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.metaborg.sdf2table.util.Graph;

public class SCCNodes<T> {
    final Graph<T> orig;
    Graph<List<T>> scc;
    List<Set<T>> sccNodes;
    Set<T> nodesComponent;
    Map<T, Set<T>> nodeSCCNodesMapping;

    public SCCNodes(Graph<T> orig) {
        this.orig = orig;
        this.sccNodes = Lists.newArrayList();
        this.nodeSCCNodesMapping = Maps.newHashMap();
    }

    public void calculateSCCNodes() {
        Stack<Integer> stack = new Stack<Integer>();
        boolean[] visited = new boolean[this.orig.totalV()];
        int i = 0;
        while (i < this.orig.totalV()) {
            visited[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.orig.totalV()) {
            if (!visited[i]) {
                this.fillOrder(i, visited, stack);
            }
            ++i;
        }
        Graph<T> gr = this.orig.getTranspose();
        int i2 = 0;
        while (i2 < this.orig.totalV()) {
            visited[i2] = false;
            ++i2;
        }
        while (!stack.empty()) {
            int v = stack.pop();
            if (visited[v]) continue;
            this.nodesComponent = Sets.newHashSet();
            this.DFSUtil(gr, v, visited);
            if (this.nodesComponent.size() <= 1) continue;
            this.sccNodes.add(this.nodesComponent);
        }
        for (Set<T> sccNode : this.sccNodes) {
            for (T origNode : sccNode) {
                this.nodeSCCNodesMapping.put(origNode, sccNode);
            }
        }
    }

    private void DFSUtil(Graph<T> g, int v, boolean[] visited) {
        visited[v] = true;
        this.nodesComponent.add(g.getLabels().inverse().get((Object)v));
        List<Integer>[] adj = g.getAdjacencyList();
        for (int n : adj[v]) {
            if (visited[n]) continue;
            this.DFSUtil(g, n, visited);
        }
    }

    private void fillOrder(int v, boolean[] visited, Stack<Integer> stack) {
        visited[v] = true;
        List<Integer>[] adj = this.orig.getAdjacencyList();
        for (int n : adj[v]) {
            if (visited[n]) continue;
            this.fillOrder(n, visited, stack);
        }
        stack.push(new Integer(v));
    }

    public Map<T, Set<T>> getNodesMapping() {
        return this.nodeSCCNodesMapping;
    }

    public List<Set<T>> getSCCNodes() {
        return this.sccNodes;
    }
}

