/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.grammar.Symbol;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SequenceSymbol
extends Symbol {
    private static final long serialVersionUID = -1328952925094286799L;
    private final Symbol first;
    private final List<Symbol> tail;

    protected SequenceSymbol(Symbol first, List<Symbol> tail) {
        this.first = first;
        this.tail = tail;
        this.followRestrictionsLookahead = Lists.newArrayList();
        this.followRestrictionsNoLookahead = null;
    }

    @Override
    public String name() {
        String name = String.valueOf(this.first.name()) + " ";
        for (Symbol s : this.tail) {
            name = String.valueOf(name) + s.name() + " ";
        }
        return name;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public IStrategoTerm toAterm(ITermFactory tf) {
        IStrategoList.Builder tail_aterm = tf.arrayListBuilder(this.tail.size());
        for (Symbol s : this.tail) {
            tail_aterm.add(s.toAterm(tf));
        }
        return tf.makeAppl(tf.makeConstructor("seq", 2), this.first.toAterm(tf), tf.makeList(tail_aterm));
    }

    @Override
    public IStrategoTerm toSDF3Aterm(ITermFactory tf, Map<Set<Context>, Integer> ctx_vals, Integer ctx_val) {
        IStrategoList.Builder tail_aterm = tf.arrayListBuilder(this.tail.size());
        for (Symbol s : this.tail) {
            tail_aterm.add(s.toSDF3Aterm(tf, ctx_vals, ctx_val));
        }
        return tf.makeAppl(tf.makeConstructor("Sequence", 2), this.first.toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeList(tail_aterm));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.tail == null ? 0 : this.tail.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceSymbol other = (SequenceSymbol)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.tail == null ? other.tail != null : !this.tail.equals(other.tail));
    }

    @Override
    public ISymbol toParseTableSymbol(SyntaxContext syntaxContext, SortCardinality cardinality) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        symbols.add(this.first.toParseTableSymbol(syntaxContext, cardinality));
        for (Symbol tailSymbol : this.tail) {
            symbols.add(tailSymbol.toParseTableSymbol(syntaxContext, cardinality));
        }
        return new org.metaborg.parsetable.symbols.SequenceSymbol(syntaxContext, cardinality, symbols);
    }
}

