/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task;

import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.ITaskResults;
import org.metaborg.runtime.task.TaskStatus;
import org.metaborg.runtime.task.TaskStorageType;
import org.metaborg.runtime.task.TaskType;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class Task
implements ITask {
    private final IStrategoAppl instruction;
    private final IStrategoList initialDependencies;
    private final TaskType type;
    private final TaskStorageType storageType;
    private final boolean shortCircuit;
    private final ITaskResults results;
    private IStrategoAppl instructionOverride = null;
    private TaskStatus status = TaskStatus.Unknown;
    private IStrategoTerm message;
    private long time = -1L;
    private short evaluations = 0;

    public Task(IStrategoAppl instruction, IStrategoList initialDependencies, TaskType type, TaskStorageType storageType, boolean shortCircuit, ITaskResults results) {
        this.instruction = instruction;
        this.initialDependencies = initialDependencies;
        this.type = type;
        this.storageType = storageType;
        this.shortCircuit = shortCircuit;
        this.results = results;
    }

    public Task(Task task) {
        this.instruction = task.instruction;
        this.initialDependencies = task.initialDependencies;
        this.type = task.type;
        this.storageType = task.storageType;
        this.shortCircuit = task.shortCircuit;
        this.results = task.results;
        this.instructionOverride = task.instructionOverride;
        this.status = task.status;
        this.message = task.message;
        this.time = task.time;
        this.evaluations = task.evaluations;
    }

    @Override
    public IStrategoAppl instruction() {
        if (this.instructionOverride == null) {
            return this.instruction;
        }
        return this.instructionOverride;
    }

    @Override
    public void overrideInstruction(IStrategoAppl newInstruction) {
        this.instructionOverride = newInstruction;
    }

    @Override
    public IStrategoAppl instructionOverride() {
        return this.instructionOverride;
    }

    @Override
    public IStrategoAppl initialInstruction() {
        return this.instruction;
    }

    @Override
    public void clearInstructionOverride() {
        this.instructionOverride = null;
    }

    @Override
    public IStrategoList initialDependencies() {
        return this.initialDependencies;
    }

    @Override
    public TaskType type() {
        return this.type;
    }

    @Override
    public TaskStorageType storageType() {
        return this.storageType;
    }

    @Override
    public TaskStorageType actualStorageType() {
        return this.results.type();
    }

    @Override
    public boolean shortCircuit() {
        return this.shortCircuit;
    }

    @Override
    public ITaskResults results() {
        return this.results;
    }

    @Override
    public TaskStatus status() {
        return this.status;
    }

    @Override
    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    @Override
    public boolean failed() {
        return this.status == TaskStatus.Fail || this.status == TaskStatus.DependencyFail;
    }

    @Override
    public void setFailed() {
        this.status = TaskStatus.Fail;
    }

    @Override
    public boolean dependencyFailed() {
        return this.status == TaskStatus.DependencyFail;
    }

    @Override
    public void setDependencyFailed() {
        this.status = TaskStatus.DependencyFail;
    }

    @Override
    public boolean solved() {
        return this.status != TaskStatus.Unknown;
    }

    @Override
    public void unsolve() {
        this.results.clear();
        this.status = TaskStatus.Unknown;
    }

    @Override
    public IStrategoTerm message() {
        return this.message;
    }

    @Override
    public void setMessage(IStrategoTerm message) {
        this.message = message;
    }

    @Override
    public void clearMessage() {
        this.message = null;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public void addTime(long time) {
        this.time += time;
    }

    @Override
    public void clearTime() {
        this.time = -1L;
    }

    @Override
    public short evaluations() {
        return this.evaluations;
    }

    @Override
    public void setEvaluations(short evaluations) {
        this.evaluations = evaluations;
    }

    @Override
    public void addEvaluation() {
        this.evaluations = (short)(this.evaluations + 1);
    }

    @Override
    public void clearEvaluations() {
        this.evaluations = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.initialDependencies == null ? 0 : this.initialDependencies.hashCode());
        result = 31 * result + (this.instruction == null ? 0 : this.instruction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        if (this.initialDependencies == null ? other.initialDependencies != null : !this.initialDependencies.equals(other.initialDependencies)) {
            return false;
        }
        return !(this.instruction == null ? other.instruction != null : !this.instruction.equals(other.instruction));
    }

    public String toString() {
        return "Task [instruction=" + this.instruction + ", type=" + (Object)((Object)this.type) + ", results=" + this.results() + ", status=" + (Object)((Object)this.status) + ", message=" + this.message + ", time=" + this.time + ", evaluations=" + this.evaluations + "]";
    }
}

