/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.store;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import mb.nabl2.terms.ITermVar;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.log.IDebugContext;
import org.metaborg.util.log.Level;

public class BaseConstraintStore
implements IConstraintStore {
    final IDebugContext debug;
    private final Deque<IConstraint> active;
    private final Multimap<ITermVar, Delayed> stuckOnVar;
    private final Multimap<CriticalEdge, Delayed> stuckOnEdge;

    public BaseConstraintStore(IDebugContext debug) {
        this.debug = debug;
        this.active = new ConcurrentLinkedDeque<IConstraint>();
        this.stuckOnVar = HashMultimap.create();
        this.stuckOnEdge = HashMultimap.create();
    }

    @Override
    public int activeSize() {
        return this.active.size();
    }

    @Override
    public int delayedSize() {
        return this.stuckOnVar.size() + this.stuckOnEdge.size();
    }

    @Override
    public void add(IConstraint constraint) {
        this.active.push(constraint);
    }

    @Override
    public IConstraint remove() throws NoSuchElementException {
        return this.active.poll();
    }

    @Override
    public void delay(IConstraint constraint, Delay delay) {
        Delayed delayed = new Delayed(constraint);
        if (!delay.vars().isEmpty()) {
            if (this.debug.isEnabled(Level.Debug)) {
                this.debug.debug("delayed {} on vars {}", constraint, delay.vars());
            }
            for (ITermVar var : delay.vars()) {
                this.stuckOnVar.put((Object)var, (Object)delayed);
            }
        } else if (!delay.criticalEdges().isEmpty()) {
            if (this.debug.isEnabled(Level.Debug)) {
                this.debug.debug("delayed {} on critical edges {}", constraint, delay.criticalEdges());
            }
            for (CriticalEdge edge : delay.criticalEdges()) {
                this.stuckOnEdge.put((Object)edge, (Object)delayed);
            }
        } else {
            throw new IllegalArgumentException("delayed for no apparent reason");
        }
    }

    @Override
    public void activateFromVars(Iterable<? extends ITermVar> vars, IDebugContext debug) {
        for (ITermVar iTermVar : vars) {
            Collection activated = this.stuckOnVar.removeAll((Object)iTermVar);
            for (Delayed delayed : activated) {
                if (!delayed.activate()) continue;
                IConstraint constraint = delayed.constraint;
                if (debug.isEnabled(Level.Debug)) {
                    debug.debug("activating {}", constraint);
                }
                this.add(constraint);
            }
        }
    }

    @Override
    public void activateFromEdges(Iterable<? extends CriticalEdge> edges, IDebugContext debug) {
        for (CriticalEdge criticalEdge : edges) {
            Collection activated = this.stuckOnEdge.removeAll((Object)criticalEdge);
            for (Delayed delayed : activated) {
                if (!delayed.activate()) continue;
                IConstraint constraint = delayed.constraint;
                if (debug.isEnabled(Level.Debug)) {
                    debug.debug("activating {}", constraint);
                }
                this.add(constraint);
            }
        }
    }

    @Override
    public Map<IConstraint, Delay> delayed() {
        HashMultimap varStuck = HashMultimap.create();
        this.stuckOnVar.entries().stream().filter(e -> !((Delayed)e.getValue()).activated).forEach(arg_0 -> BaseConstraintStore.lambda$1((Multimap)varStuck, arg_0));
        HashMultimap edgeStuck = HashMultimap.create();
        this.stuckOnEdge.entries().stream().filter(e -> !((Delayed)e.getValue()).activated).forEach(arg_0 -> BaseConstraintStore.lambda$3((Multimap)edgeStuck, arg_0));
        HashSet stuck = new HashSet();
        stuck.addAll(varStuck.keys());
        stuck.addAll(edgeStuck.keys());
        ImmutableMap.Builder delayed = ImmutableMap.builder();
        stuck.stream().forEach(arg_0 -> BaseConstraintStore.lambda$4(delayed, (Multimap)varStuck, (Multimap)edgeStuck, arg_0));
        return delayed.build();
    }

    @Override
    public Iterable<IConstraint> active() {
        return Collections.unmodifiableCollection(this.active);
    }

    private static /* synthetic */ void lambda$1(Multimap multimap, Map.Entry e) {
        boolean bl = multimap.put((Object)((Delayed)e.getValue()).constraint, (Object)((ITermVar)e.getKey()));
    }

    private static /* synthetic */ void lambda$3(Multimap multimap, Map.Entry e) {
        boolean bl = multimap.put((Object)((Delayed)e.getValue()).constraint, (Object)((CriticalEdge)e.getKey()));
    }

    private static /* synthetic */ void lambda$4(ImmutableMap.Builder builder, Multimap multimap, Multimap multimap2, IConstraint c) {
        ImmutableMap.Builder builder2 = builder.put((Object)c, (Object)new Delay(multimap.get((Object)c), multimap2.get((Object)c)));
    }

    private static class Delayed {
        public final IConstraint constraint;
        private boolean activated = false;

        public Delayed(IConstraint constraint) {
            this.constraint = constraint;
        }

        public boolean activate() {
            if (this.activated) {
                return false;
            }
            this.activated = true;
            return true;
        }

        public String toString() {
            return this.activated ? "*" : this.constraint.toString();
        }
    }
}

