/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.ASolverResult;
import mb.statix.spec.Spec;

public final class SolverResult
extends ASolverResult
implements Serializable {
    private final Spec spec;
    private final IState.Immutable state;
    private final ImmutableMap<IConstraint, IMessage> messages;
    private final ImmutableMap<IConstraint, Delay> delays;
    private final ImmutableMap<ITermVar, ITermVar> existentials;
    private final ImmutableSet<ITermVar> updatedVars;
    private final ImmutableSet<CriticalEdge> removedEdges;
    private final ICompleteness.Immutable completeness;
    private final int totalSolved;
    private final int totalCriticalEdges;
    private int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private SolverResult(Spec spec, IState.Immutable state, Map<? extends IConstraint, ? extends IMessage> messages, Map<? extends IConstraint, ? extends Delay> delays, Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Iterable<? extends CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        this.spec = Objects.requireNonNull(spec, "spec");
        this.state = Objects.requireNonNull(state, "state");
        this.messages = ImmutableMap.copyOf(messages);
        this.delays = ImmutableMap.copyOf(delays);
        this.existentials = ImmutableMap.copyOf(existentials);
        this.updatedVars = ImmutableSet.copyOf(updatedVars);
        this.removedEdges = ImmutableSet.copyOf(removedEdges);
        this.completeness = Objects.requireNonNull(completeness, "completeness");
        this.totalSolved = this.initShim.totalSolved();
        this.totalCriticalEdges = this.initShim.totalCriticalEdges();
        this.initShim = null;
    }

    private SolverResult(Builder builder) {
        this.spec = builder.spec;
        this.state = builder.state;
        this.messages = builder.messages.build();
        this.delays = builder.delays.build();
        this.existentials = builder.existentials.build();
        this.updatedVars = builder.updatedVars.build();
        this.removedEdges = builder.removedEdges.build();
        this.completeness = builder.completeness;
        if (builder.totalSolvedIsSet()) {
            this.initShim.totalSolved(builder.totalSolved);
        }
        if (builder.totalCriticalEdgesIsSet()) {
            this.initShim.totalCriticalEdges(builder.totalCriticalEdges);
        }
        this.totalSolved = this.initShim.totalSolved();
        this.totalCriticalEdges = this.initShim.totalCriticalEdges();
        this.initShim = null;
    }

    private SolverResult(Spec spec, IState.Immutable state, ImmutableMap<IConstraint, IMessage> messages, ImmutableMap<IConstraint, Delay> delays, ImmutableMap<ITermVar, ITermVar> existentials, ImmutableSet<ITermVar> updatedVars, ImmutableSet<CriticalEdge> removedEdges, ICompleteness.Immutable completeness, int totalSolved, int totalCriticalEdges) {
        this.spec = spec;
        this.state = state;
        this.messages = messages;
        this.delays = delays;
        this.existentials = existentials;
        this.updatedVars = updatedVars;
        this.removedEdges = removedEdges;
        this.completeness = completeness;
        this.totalSolved = totalSolved;
        this.totalCriticalEdges = totalCriticalEdges;
        this.initShim = null;
    }

    @Override
    public Spec spec() {
        return this.spec;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    public ImmutableMap<IConstraint, IMessage> messages() {
        return this.messages;
    }

    public ImmutableMap<IConstraint, Delay> delays() {
        return this.delays;
    }

    public ImmutableMap<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    public ImmutableSet<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    public ImmutableSet<CriticalEdge> removedEdges() {
        return this.removedEdges;
    }

    @Override
    public ICompleteness.Immutable completeness() {
        return this.completeness;
    }

    @Override
    public int totalSolved() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalSolved() : this.totalSolved;
    }

    @Override
    public int totalCriticalEdges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalCriticalEdges() : this.totalCriticalEdges;
    }

    public final SolverResult withSpec(Spec value) {
        if (this.spec == value) {
            return this;
        }
        Spec newValue = Objects.requireNonNull(value, "spec");
        return new SolverResult(newValue, this.state, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new SolverResult(this.spec, newValue, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withMessages(Map<? extends IConstraint, ? extends IMessage> entries) {
        if (this.messages == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this.spec, this.state, (ImmutableMap<IConstraint, IMessage>)newValue, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withDelays(Map<? extends IConstraint, ? extends Delay> entries) {
        if (this.delays == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this.spec, this.state, this.messages, (ImmutableMap<IConstraint, Delay>)newValue, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
        if (this.existentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this.spec, this.state, this.messages, this.delays, (ImmutableMap<ITermVar, ITermVar>)newValue, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withUpdatedVars(ITermVar ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, (ImmutableSet<ITermVar>)newValue, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withUpdatedVars(Iterable<? extends ITermVar> elements) {
        if (this.updatedVars == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, (ImmutableSet<ITermVar>)newValue, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withRemovedEdges(CriticalEdge ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, this.updatedVars, (ImmutableSet<CriticalEdge>)newValue, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withRemovedEdges(Iterable<? extends CriticalEdge> elements) {
        if (this.removedEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, this.updatedVars, (ImmutableSet<CriticalEdge>)newValue, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withCompleteness(ICompleteness.Immutable value) {
        if (this.completeness == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "completeness");
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, newValue, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult withTotalSolved(int value) {
        if (this.totalSolved == value) {
            return this;
        }
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, value, this.totalCriticalEdges);
    }

    public final SolverResult withTotalCriticalEdges(int value) {
        if (this.totalCriticalEdges == value) {
            return this;
        }
        return new SolverResult(this.spec, this.state, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverResult && this.equalTo((SolverResult)another);
    }

    private boolean equalTo(SolverResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.spec.equals(another.spec) && this.state.equals(another.state) && this.messages.equals(another.messages) && this.delays.equals(another.delays) && this.existentials.equals(another.existentials) && this.updatedVars.equals(another.updatedVars) && this.removedEdges.equals(another.removedEdges) && this.completeness.equals(another.completeness) && this.totalSolved == another.totalSolved && this.totalCriticalEdges == another.totalCriticalEdges;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.delays.hashCode();
        h += (h << 5) + this.existentials.hashCode();
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.removedEdges.hashCode();
        h += (h << 5) + this.completeness.hashCode();
        h += (h << 5) + this.totalSolved;
        h += (h << 5) + this.totalCriticalEdges;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SolverResult").omitNullValues().add("spec", (Object)this.spec).add("state", (Object)this.state).add("messages", this.messages).add("delays", this.delays).add("existentials", this.existentials).add("updatedVars", this.updatedVars).add("removedEdges", this.removedEdges).add("completeness", (Object)this.completeness).add("totalSolved", this.totalSolved).add("totalCriticalEdges", this.totalCriticalEdges).toString();
    }

    public static SolverResult of(Spec spec, IState.Immutable state, Map<IConstraint, IMessage> messages, Map<IConstraint, Delay> delays, Map<ITermVar, ITermVar> existentials, Set<ITermVar> updatedVars, Set<CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        return SolverResult.of(spec, state, messages, delays, existentials, updatedVars, removedEdges, completeness);
    }

    public static SolverResult of(Spec spec, IState.Immutable state, Map<? extends IConstraint, ? extends IMessage> messages, Map<? extends IConstraint, ? extends Delay> delays, Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Iterable<? extends CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        return new SolverResult(spec, state, messages, delays, existentials, updatedVars, removedEdges, completeness);
    }

    public static SolverResult copyOf(ASolverResult instance) {
        if (instance instanceof SolverResult) {
            return (SolverResult)instance;
        }
        return SolverResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SolverResult(Builder builder, SolverResult solverResult) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_SPEC = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_COMPLETENESS = 4L;
        private static final long OPT_BIT_TOTAL_SOLVED = 1L;
        private static final long OPT_BIT_TOTAL_CRITICAL_EDGES = 2L;
        private long initBits = 7L;
        private long optBits;
        private Spec spec;
        private IState.Immutable state;
        private ImmutableMap.Builder<IConstraint, IMessage> messages = ImmutableMap.builder();
        private ImmutableMap.Builder<IConstraint, Delay> delays = ImmutableMap.builder();
        private ImmutableMap.Builder<ITermVar, ITermVar> existentials = ImmutableMap.builder();
        private ImmutableSet.Builder<ITermVar> updatedVars = ImmutableSet.builder();
        private ImmutableSet.Builder<CriticalEdge> removedEdges = ImmutableSet.builder();
        private ICompleteness.Immutable completeness;
        private int totalSolved;
        private int totalCriticalEdges;

        private Builder() {
        }

        public final Builder from(ASolverResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.spec(instance.spec());
            this.state(instance.state());
            this.putAllMessages(instance.messages());
            this.putAllDelays(instance.delays());
            this.putAllExistentials(instance.existentials());
            this.addAllUpdatedVars(instance.updatedVars());
            this.addAllRemovedEdges(instance.removedEdges());
            this.completeness(instance.completeness());
            this.totalSolved(instance.totalSolved());
            this.totalCriticalEdges(instance.totalCriticalEdges());
            return this;
        }

        public final Builder spec(Spec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putMessages(IConstraint key, IMessage value) {
            this.messages.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMessages(Map.Entry<? extends IConstraint, ? extends IMessage> entry) {
            this.messages.put(entry);
            return this;
        }

        public final Builder messages(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.messages = ImmutableMap.builder();
            return this.putAllMessages(entries);
        }

        public final Builder putAllMessages(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.messages.putAll(entries);
            return this;
        }

        public final Builder putDelays(IConstraint key, Delay value) {
            this.delays.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putDelays(Map.Entry<? extends IConstraint, ? extends Delay> entry) {
            this.delays.put(entry);
            return this;
        }

        public final Builder delays(Map<? extends IConstraint, ? extends Delay> entries) {
            this.delays = ImmutableMap.builder();
            return this.putAllDelays(entries);
        }

        public final Builder putAllDelays(Map<? extends IConstraint, ? extends Delay> entries) {
            this.delays.putAll(entries);
            return this;
        }

        public final Builder putExistentials(ITermVar key, ITermVar value) {
            this.existentials.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putExistentials(Map.Entry<? extends ITermVar, ? extends ITermVar> entry) {
            this.existentials.put(entry);
            return this;
        }

        public final Builder existentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials = ImmutableMap.builder();
            return this.putAllExistentials(entries);
        }

        public final Builder putAllExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials.putAll(entries);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar element) {
            this.updatedVars.add((Object)element);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar ... elements) {
            this.updatedVars.add((Object[])elements);
            return this;
        }

        public final Builder updatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars = ImmutableSet.builder();
            return this.addAllUpdatedVars(elements);
        }

        public final Builder addAllUpdatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars.addAll(elements);
            return this;
        }

        public final Builder addRemovedEdges(CriticalEdge element) {
            this.removedEdges.add((Object)element);
            return this;
        }

        public final Builder addRemovedEdges(CriticalEdge ... elements) {
            this.removedEdges.add((Object[])elements);
            return this;
        }

        public final Builder removedEdges(Iterable<? extends CriticalEdge> elements) {
            this.removedEdges = ImmutableSet.builder();
            return this.addAllRemovedEdges(elements);
        }

        public final Builder addAllRemovedEdges(Iterable<? extends CriticalEdge> elements) {
            this.removedEdges.addAll(elements);
            return this;
        }

        public final Builder completeness(ICompleteness.Immutable completeness) {
            this.completeness = Objects.requireNonNull(completeness, "completeness");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder totalSolved(int totalSolved) {
            this.totalSolved = totalSolved;
            this.optBits |= 1L;
            return this;
        }

        public final Builder totalCriticalEdges(int totalCriticalEdges) {
            this.totalCriticalEdges = totalCriticalEdges;
            this.optBits |= 2L;
            return this;
        }

        public SolverResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SolverResult(this, null);
        }

        private boolean totalSolvedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean totalCriticalEdgesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("completeness");
            }
            return "Cannot build SolverResult, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte totalSolvedBuildStage = 0;
        private int totalSolved;
        private byte totalCriticalEdgesBuildStage = 0;
        private int totalCriticalEdges;

        private InitShim() {
        }

        int totalSolved() {
            if (this.totalSolvedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalSolvedBuildStage == 0) {
                this.totalSolvedBuildStage = (byte)-1;
                this.totalSolved = SolverResult.super.totalSolved();
                this.totalSolvedBuildStage = 1;
            }
            return this.totalSolved;
        }

        void totalSolved(int totalSolved) {
            this.totalSolved = totalSolved;
            this.totalSolvedBuildStage = 1;
        }

        int totalCriticalEdges() {
            if (this.totalCriticalEdgesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalCriticalEdgesBuildStage == 0) {
                this.totalCriticalEdgesBuildStage = (byte)-1;
                this.totalCriticalEdges = SolverResult.super.totalCriticalEdges();
                this.totalCriticalEdgesBuildStage = 1;
            }
            return this.totalCriticalEdges;
        }

        void totalCriticalEdges(int totalCriticalEdges) {
            this.totalCriticalEdges = totalCriticalEdges;
            this.totalCriticalEdgesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.totalSolvedBuildStage == -1) {
                attributes.add("totalSolved");
            }
            if (this.totalCriticalEdgesBuildStage == -1) {
                attributes.add("totalCriticalEdges");
            }
            return "Cannot build SolverResult, attribute initializers form cycle " + attributes;
        }
    }
}

