/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.statix.concurrent.ASolverState;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;

public final class SolverState
extends ASolverState
implements Serializable {
    private final IState.Immutable state;
    private final ICompleteness.Immutable completeness;
    private final ImmutableSet<IConstraint> constraints;
    @Nullable
    private final ImmutableMap<ITermVar, ITermVar> existentials;
    private final ImmutableList<ITermVar> updatedVars;
    private final ImmutableMap<IConstraint, IMessage> failed;
    private final Set.Immutable<CriticalEdge> delayedCloses;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private SolverState(IState.Immutable state, ICompleteness.Immutable completeness, Iterable<? extends IConstraint> constraints, @Nullable Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Map<? extends IConstraint, ? extends IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        this.state = Objects.requireNonNull(state, "state");
        this.completeness = Objects.requireNonNull(completeness, "completeness");
        this.constraints = ImmutableSet.copyOf(constraints);
        this.existentials = existentials == null ? null : ImmutableMap.copyOf(existentials);
        this.updatedVars = ImmutableList.copyOf(updatedVars);
        this.failed = ImmutableMap.copyOf(failed);
        this.delayedCloses = Objects.requireNonNull(delayedCloses, "delayedCloses");
    }

    private SolverState(SolverState original, IState.Immutable state, ICompleteness.Immutable completeness, ImmutableSet<IConstraint> constraints, @Nullable ImmutableMap<ITermVar, ITermVar> existentials, ImmutableList<ITermVar> updatedVars, ImmutableMap<IConstraint, IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        this.state = state;
        this.completeness = completeness;
        this.constraints = constraints;
        this.existentials = existentials;
        this.updatedVars = updatedVars;
        this.failed = failed;
        this.delayedCloses = delayedCloses;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    @Override
    public ICompleteness.Immutable completeness() {
        return this.completeness;
    }

    public ImmutableSet<IConstraint> constraints() {
        return this.constraints;
    }

    @Nullable
    public ImmutableMap<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    public ImmutableList<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    public ImmutableMap<IConstraint, IMessage> failed() {
        return this.failed;
    }

    @Override
    public Set.Immutable<CriticalEdge> delayedCloses() {
        return this.delayedCloses;
    }

    public final SolverState withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new SolverState(this, newValue, this.completeness, this.constraints, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withCompleteness(ICompleteness.Immutable value) {
        if (this.completeness == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "completeness");
        return new SolverState(this, this.state, newValue, this.constraints, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withConstraints(IConstraint ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new SolverState(this, this.state, this.completeness, (ImmutableSet<IConstraint>)newValue, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new SolverState(this, this.state, this.completeness, (ImmutableSet<IConstraint>)newValue, this.existentials, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withExistentials(@Nullable Map<? extends ITermVar, ? extends ITermVar> entries) {
        if (this.existentials == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new SolverState(this, this.state, this.completeness, this.constraints, (ImmutableMap<ITermVar, ITermVar>)newValue, this.updatedVars, this.failed, this.delayedCloses);
    }

    public final SolverState withUpdatedVars(ITermVar ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, (ImmutableList<ITermVar>)newValue, this.failed, this.delayedCloses);
    }

    public final SolverState withUpdatedVars(Iterable<? extends ITermVar> elements) {
        if (this.updatedVars == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, (ImmutableList<ITermVar>)newValue, this.failed, this.delayedCloses);
    }

    public final SolverState withFailed(Map<? extends IConstraint, ? extends IMessage> entries) {
        if (this.failed == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, this.updatedVars, (ImmutableMap<IConstraint, IMessage>)newValue, this.delayedCloses);
    }

    public final SolverState withDelayedCloses(Set.Immutable<CriticalEdge> value) {
        if (this.delayedCloses == value) {
            return this;
        }
        Set.Immutable<CriticalEdge> newValue = Objects.requireNonNull(value, "delayedCloses");
        return new SolverState(this, this.state, this.completeness, this.constraints, this.existentials, this.updatedVars, this.failed, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverState && this.equalTo((SolverState)another);
    }

    private boolean equalTo(SolverState another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.state.equals(another.state) && this.completeness.equals(another.completeness) && this.constraints.equals(another.constraints) && Objects.equals(this.existentials, another.existentials) && this.updatedVars.equals(another.updatedVars) && this.failed.equals(another.failed) && this.delayedCloses.equals(another.delayedCloses);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.completeness.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + Objects.hashCode(this.existentials);
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.failed.hashCode();
        h += (h << 5) + this.delayedCloses.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SolverState").omitNullValues().add("state", (Object)this.state).add("completeness", (Object)this.completeness).add("constraints", this.constraints).add("existentials", this.existentials).add("updatedVars", this.updatedVars).add("failed", this.failed).add("delayedCloses", this.delayedCloses).toString();
    }

    public static SolverState of(IState.Immutable state, ICompleteness.Immutable completeness, Set<IConstraint> constraints, @Nullable Map<ITermVar, ITermVar> existentials, List<ITermVar> updatedVars, Map<IConstraint, IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        return SolverState.of(state, completeness, constraints, existentials, updatedVars, failed, delayedCloses);
    }

    public static SolverState of(IState.Immutable state, ICompleteness.Immutable completeness, Iterable<? extends IConstraint> constraints, @Nullable Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Map<? extends IConstraint, ? extends IMessage> failed, Set.Immutable<CriticalEdge> delayedCloses) {
        return new SolverState(state, completeness, constraints, existentials, updatedVars, failed, delayedCloses);
    }

    public static SolverState copyOf(ASolverState instance) {
        if (instance instanceof SolverState) {
            return (SolverState)instance;
        }
        return SolverState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SolverState(SolverState solverState, IState.Immutable immutable, ICompleteness.Immutable immutable2, ImmutableSet immutableSet, ImmutableMap immutableMap, ImmutableList immutableList, ImmutableMap immutableMap2, Set.Immutable immutable3, SolverState solverState2) {
        this(solverState, immutable, immutable2, (ImmutableSet<IConstraint>)immutableSet, (ImmutableMap<ITermVar, ITermVar>)immutableMap, (ImmutableList<ITermVar>)immutableList, (ImmutableMap<IConstraint, IMessage>)immutableMap2, (Set.Immutable<CriticalEdge>)immutable3);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long INIT_BIT_COMPLETENESS = 2L;
        private static final long INIT_BIT_DELAYED_CLOSES = 4L;
        private long initBits = 7L;
        private IState.Immutable state;
        private ICompleteness.Immutable completeness;
        private ImmutableSet.Builder<IConstraint> constraints = ImmutableSet.builder();
        private ImmutableMap.Builder<ITermVar, ITermVar> existentials = null;
        private ImmutableList.Builder<ITermVar> updatedVars = ImmutableList.builder();
        private ImmutableMap.Builder<IConstraint, IMessage> failed = ImmutableMap.builder();
        private Set.Immutable<CriticalEdge> delayedCloses;

        private Builder() {
        }

        public final Builder from(ASolverState instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.completeness(instance.completeness());
            this.addAllConstraints(instance.constraints());
            Map<ITermVar, ITermVar> existentialsValue = instance.existentials();
            if (existentialsValue != null) {
                this.putAllExistentials(existentialsValue);
            }
            this.addAllUpdatedVars(instance.updatedVars());
            this.putAllFailed(instance.failed());
            this.delayedCloses(instance.delayedCloses());
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder completeness(ICompleteness.Immutable completeness) {
            this.completeness = Objects.requireNonNull(completeness, "completeness");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addConstraints(IConstraint element) {
            this.constraints.add((Object)element);
            return this;
        }

        public final Builder addConstraints(IConstraint ... elements) {
            this.constraints.add((Object[])elements);
            return this;
        }

        public final Builder constraints(Iterable<? extends IConstraint> elements) {
            this.constraints = ImmutableSet.builder();
            return this.addAllConstraints(elements);
        }

        public final Builder addAllConstraints(Iterable<? extends IConstraint> elements) {
            this.constraints.addAll(elements);
            return this;
        }

        public final Builder putExistentials(ITermVar key, ITermVar value) {
            if (this.existentials == null) {
                this.existentials = ImmutableMap.builder();
            }
            this.existentials.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putExistentials(Map.Entry<? extends ITermVar, ? extends ITermVar> entry) {
            if (this.existentials == null) {
                this.existentials = ImmutableMap.builder();
            }
            this.existentials.put(entry);
            return this;
        }

        public final Builder existentials(@Nullable Map<? extends ITermVar, ? extends ITermVar> entries) {
            if (entries == null) {
                this.existentials = null;
                return this;
            }
            this.existentials = ImmutableMap.builder();
            return this.putAllExistentials(entries);
        }

        public final Builder putAllExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            if (this.existentials == null) {
                this.existentials = ImmutableMap.builder();
            }
            this.existentials.putAll(entries);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar element) {
            this.updatedVars.add((Object)element);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar ... elements) {
            this.updatedVars.add((Object[])elements);
            return this;
        }

        public final Builder updatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars = ImmutableList.builder();
            return this.addAllUpdatedVars(elements);
        }

        public final Builder addAllUpdatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars.addAll(elements);
            return this;
        }

        public final Builder putFailed(IConstraint key, IMessage value) {
            this.failed.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putFailed(Map.Entry<? extends IConstraint, ? extends IMessage> entry) {
            this.failed.put(entry);
            return this;
        }

        public final Builder failed(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.failed = ImmutableMap.builder();
            return this.putAllFailed(entries);
        }

        public final Builder putAllFailed(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.failed.putAll(entries);
            return this;
        }

        public final Builder delayedCloses(Set.Immutable<CriticalEdge> delayedCloses) {
            this.delayedCloses = Objects.requireNonNull(delayedCloses, "delayedCloses");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SolverState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SolverState(null, this.state, this.completeness, this.constraints.build(), this.existentials == null ? null : this.existentials.build(), this.updatedVars.build(), this.failed.build(), this.delayedCloses, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("completeness");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("delayedCloses");
            }
            return "Cannot build SolverState, some of required attributes are not set " + attributes;
        }
    }
}

