/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.arithmetic;

import java.io.Serializable;
import java.util.Arrays;
import mb.nabl2.terms.matching.TermMatch;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.arithmetic.ArithTest;
import mb.statix.arithmetic.BinExpr;
import mb.statix.arithmetic.TermExpr;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.functions.Predicate2;

public class ArithTerms {
    public static TermMatch.IMatcher<ArithTest> matchTest() {
        return TermMatch.M.cases(TermMatch.M.appl0("Equal", t -> new ArithTest("=", new Eq(), true)), TermMatch.M.appl0("NotEqual", t -> new ArithTest("\\=", new Neq(), false)), TermMatch.M.appl0("GreaterThanEqual", t -> new ArithTest(">=", new Gte(), false)), TermMatch.M.appl0("LessThanEqual", t -> new ArithTest("=<", new Lte(), false)), TermMatch.M.appl0("GreaterThan", t -> new ArithTest(">", new Ge(), false)), TermMatch.M.appl0("LessThan", t -> new ArithTest("<", new Le(), false)));
    }

    public static TermMatch.IMatcher<ArithExpr> matchExpr() {
        return TermMatch.M.casesFix(m -> Arrays.asList(StatixTerms.varTerm().map(TermExpr::new), StatixTerms.intTerm().map(TermExpr::new), TermMatch.M.appl2("Add", m, m, (t, ae1, ae2) -> new BinExpr("+", (ArithExpr)ae1, (ArithExpr)ae2, new Add())), TermMatch.M.appl2("Mul", m, m, (t, ae1, ae2) -> new BinExpr("*", (ArithExpr)ae1, (ArithExpr)ae2, new Mul())), TermMatch.M.appl2("Sub", m, m, (t, ae1, ae2) -> new BinExpr("-", (ArithExpr)ae1, (ArithExpr)ae2, new Sub())), TermMatch.M.appl2("Min", m, m, (t, ae1, ae2) -> new BinExpr("min", (ArithExpr)ae1, (ArithExpr)ae2, new Min())), TermMatch.M.appl2("Max", m, m, (t, ae1, ae2) -> new BinExpr("max", (ArithExpr)ae1, (ArithExpr)ae2, new Max())), TermMatch.M.appl2("Mod", m, m, (t, ae1, ae2) -> new BinExpr("mod", (ArithExpr)ae1, (ArithExpr)ae2, new Mod())), TermMatch.M.appl2("Div", m, m, (t, ae1, ae2) -> new BinExpr("div", (ArithExpr)ae1, (ArithExpr)ae2, new Div()))));
    }

    private static class Add
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Add() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return i1 + i2;
        }
    }

    private static class Div
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Div() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return Math.floorDiv(i1, (int)i2);
        }
    }

    private static class Eq
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Eq() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 == i2;
        }
    }

    private static class Ge
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Ge() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 > i2;
        }
    }

    private static class Gte
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Gte() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 >= i2;
        }
    }

    private static class Le
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Le() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 < i2;
        }
    }

    private static class Lte
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Lte() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 <= i2;
        }
    }

    private static class Max
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Max() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return Math.max(i1, i2);
        }
    }

    private static class Min
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Min() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return Math.min(i1, i2);
        }
    }

    private static class Mod
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Mod() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return Math.floorMod(i1, (int)i2);
        }
    }

    private static class Mul
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Mul() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return i1 * i2;
        }
    }

    private static class Neq
    implements Predicate2<Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Neq() {
        }

        @Override
        public boolean test(Integer i1, Integer i2) {
            return i1 != i2;
        }
    }

    private static class Sub
    implements Function2<Integer, Integer, Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Sub() {
        }

        @Override
        public Integer apply(Integer i1, Integer i2) {
            return i1 - i2;
        }
    }
}

