/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RVar;

public class RCExp<L>
implements RExp<L>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RVar env;
    private final RExp<L> exp;

    public RCExp(RVar env, RExp<L> exp) {
        this.env = env;
        this.exp = exp;
    }

    public RVar env() {
        return this.env;
    }

    public RExp<L> exp() {
        return this.exp;
    }

    @Override
    public <R> R match(RExp.Cases<L, R> cases) {
        return cases.caseCExp(this.env, this.exp);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(RExp.ResolutionCases<L, R> cases) throws ResolutionException, InterruptedException {
        return cases.caseCExp(this.env, this.exp);
    }

    public String toString() {
        return "if not empty " + this.env + " else " + this.exp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RCExp other = (RCExp)obj;
        return Objects.equals(this.env, other.env) && Objects.equals(this.exp, other.exp);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.exp);
    }
}

