/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.regexp.impl.ASymbol;

final class Symbol<S>
extends ASymbol<S>
implements Serializable {
    private final S symbol;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private Symbol(S symbol) {
        this.symbol = Objects.requireNonNull(symbol, "symbol");
    }

    private Symbol(Symbol<S> original, S symbol) {
        this.symbol = symbol;
    }

    @Override
    public S getSymbol() {
        return this.symbol;
    }

    public final Symbol<S> withSymbol(S value) {
        if (this.symbol == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "symbol");
        return new Symbol<S>(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Symbol && this.equalTo((Symbol)another);
    }

    private boolean equalTo(Symbol<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.symbol.equals(another.symbol);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.symbol.hashCode();
        return h;
    }

    public static <S> Symbol<S> of(S symbol) {
        return new Symbol<S>(symbol);
    }

    public static <S> Symbol<S> copyOf(ASymbol<S> instance) {
        if (instance instanceof Symbol) {
            return (Symbol)instance;
        }
        return Symbol.of(instance.getSymbol());
    }
}

