/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.terms.Namespace;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.OccurrenceIndex;
import mb.scopegraph.pepm16.terms.SpacedName;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AOccurrence
extends AbstractApplTerm
implements IOccurrence,
IApplTerm,
Comparable<IOccurrence> {
    private static final String OP = "Occurrence";

    @Override
    @Value.Parameter
    public abstract Namespace getNamespace();

    @Override
    @Value.Parameter
    public abstract ITerm getName();

    @Override
    @Value.Parameter
    public abstract OccurrenceIndex getIndex();

    @Override
    public ITerm getNameOrIndexOrigin() {
        return TermOrigin.get(this.getName()).map(o -> this.getName()).orElseGet(this::getIndex);
    }

    @Override
    @Value.Lazy
    public SpacedName getSpacedName() {
        return SpacedName.of(this.getNamespace(), this.getName());
    }

    @Override
    @Value.Lazy
    public String getOp() {
        return OP;
    }

    @Override
    @Value.Lazy
    public List<ITerm> getArgs() {
        return ImmutableList.of((Object)this.getNamespace(), (Object)this.getName(), (Object)this.getIndex());
    }

    public static TermMatch.IMatcher<Occurrence> matcher() {
        return TermMatch.M.preserveAttachments(TermMatch.M.appl3(OP, Namespace.matcher(), TermMatch.M.ground(TermMatch.M.term()), OccurrenceIndex.matcher(), (t, namespace, name, index) -> Occurrence.of(namespace, name, index)));
    }

    @Override
    protected AOccurrence check() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Occurrence)) {
            return super.equals(other);
        }
        Occurrence that = (Occurrence)other;
        if (!this.getNamespace().equals(that.getNamespace())) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getIndex().equals(that.getIndex());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNamespace().getName());
        sb.append("{");
        sb.append(this.getName());
        sb.append(" ");
        sb.append(this.getIndex());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(IOccurrence other) {
        int diffNamespace = this.getNamespace().getName().compareTo(other.getNamespace().getName());
        if (diffNamespace != 0) {
            return diffNamespace;
        }
        int diffName = this.getName().toString().compareTo(other.getName().toString());
        if (diffName != 0) {
            return diffName;
        }
        int diffIndex = this.getIndex().toString().compareTo(other.getIndex().toString());
        return diffIndex;
    }
}

