/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.util.ArrayList;
import java.util.Collections;
import mb.resource.hierarchical.match.path.string.PathStringMatcher;
import mb.resource.util.AntPattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AntPatternsPathStringMatcher
implements PathStringMatcher {
    private final ArrayList<AntPattern> patterns;

    public AntPatternsPathStringMatcher(ArrayList<AntPattern> patterns) {
        this.patterns = patterns;
    }

    public AntPatternsPathStringMatcher(Iterable<AntPattern> patterns) {
        this.patterns = new ArrayList();
        for (AntPattern pattern : patterns) {
            this.patterns.add(pattern);
        }
    }

    public AntPatternsPathStringMatcher(AntPattern ... patterns) {
        this.patterns = new ArrayList();
        Collections.addAll(this.patterns, patterns);
    }

    public AntPatternsPathStringMatcher(String ... patterns) {
        this.patterns = new ArrayList();
        for (String pattern : patterns) {
            this.patterns.add(new AntPattern(pattern));
        }
    }

    @Override
    public boolean matches(String pathString) {
        for (AntPattern pattern : this.patterns) {
            if (!pattern.match(pathString)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntPatternsPathStringMatcher that = (AntPatternsPathStringMatcher)o;
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return "AntPatternsPathStringMatcher(" + this.patterns + ')';
    }
}

