/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import mb.resource.classloader.JarFileWithPath;
import mb.resource.hierarchical.HierarchicalResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassLoaderResourceLocations<R extends HierarchicalResource>
implements Serializable {
    public final ArrayList<R> directories;
    public final ArrayList<JarFileWithPath<R>> jarFiles;
    public final ArrayList<URL> unrecognizedUrls;

    public ClassLoaderResourceLocations(ArrayList<R> directories, ArrayList<JarFileWithPath<R>> jarFiles, ArrayList<URL> unrecognizedUrls) {
        this.directories = directories;
        this.jarFiles = jarFiles;
        this.unrecognizedUrls = unrecognizedUrls;
    }

    public ClassLoaderResourceLocations() {
        this(new ArrayList(), new ArrayList<JarFileWithPath<R>>(), new ArrayList<URL>());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderResourceLocations that = (ClassLoaderResourceLocations)o;
        if (!this.directories.equals(that.directories)) {
            return false;
        }
        if (!this.jarFiles.equals(that.jarFiles)) {
            return false;
        }
        return this.unrecognizedUrls.equals(that.unrecognizedUrls);
    }

    public int hashCode() {
        int result = this.directories.hashCode();
        result = 31 * result + this.jarFiles.hashCode();
        result = 31 * result + this.unrecognizedUrls.hashCode();
        return result;
    }

    public String toString() {
        return "ClassLoaderResourceLocations{directories=" + this.directories + ", jarFiles=" + this.jarFiles + ", unrecognizedUrls=" + this.unrecognizedUrls + '}';
    }
}

