/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import mb.log.api.Logger;
import mb.log.api.LoggerFactory;
import mb.log.noop.NoopLogger;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.MapTaskDefs;
import mb.pie.api.Observability;
import mb.pie.api.ResourceProvideDep;
import mb.pie.api.ResourceRequireDep;
import mb.pie.api.STask;
import mb.pie.api.STaskDef;
import mb.pie.api.Supplier;
import mb.pie.api.Task;
import mb.pie.api.TaskDef;
import mb.pie.api.TaskDefs;
import mb.pie.api.TaskRequireDep;
import mb.pie.api.UncheckedExecException;
import mb.pie.api.exec.CancelToken;
import mb.pie.api.exec.NullCancelableToken;
import mb.pie.api.stamp.OutputStamper;
import mb.pie.api.stamp.ResourceStamper;
import mb.pie.api.stamp.output.OutputStampers;
import mb.pie.api.stamp.resource.ResourceStampers;
import mb.resource.DefaultResourceService;
import mb.resource.ReadableResource;
import mb.resource.Resource;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceService;
import mb.resource.fs.FSResourceRegistry;
import mb.resource.hierarchical.HierarchicalResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MockExecContext
implements ExecContext {
    private final TaskDefs taskDefs;
    private final ResourceService resourceService;
    private final Logger logger;
    private @Nullable Serializable internalObject = null;

    public MockExecContext(TaskDefs taskDefs, ResourceService resourceService, Logger logger) {
        this.taskDefs = taskDefs;
        this.resourceService = resourceService;
        this.logger = logger;
    }

    public MockExecContext(TaskDefs taskDefs, ResourceService resourceService, LoggerFactory loggerFactory) {
        this(taskDefs, resourceService, loggerFactory.create(MockExecContext.class));
    }

    public MockExecContext(TaskDefs taskDefs, ResourceService resourceService) {
        this(taskDefs, resourceService, NoopLogger.instance);
    }

    public MockExecContext(TaskDefs taskDefs) {
        this(taskDefs, new DefaultResourceService((ResourceRegistry)new FSResourceRegistry(), new ResourceRegistry[0]));
    }

    public MockExecContext() {
        this(new MapTaskDefs());
    }

    @Override
    public <I extends Serializable, O extends Serializable> O require(TaskDef<I, O> taskDef, I input) {
        try {
            return taskDef.exec(this, input);
        }
        catch (Exception e) {
            throw new UncheckedExecException("Executing task '" + taskDef.desc(input, 100) + "' failed unexpectedly", e);
        }
    }

    @Override
    public <I extends Serializable, O extends Serializable> O require(TaskDef<I, O> taskDef, I input, OutputStamper stamper) {
        return this.require(taskDef, input);
    }

    @Override
    public <O extends Serializable> O require(Task<O> task) {
        return this.require(task.taskDef, task.input);
    }

    @Override
    public <O extends Serializable> O require(Task<O> task, OutputStamper stamper) {
        return this.require(task.taskDef, task.input);
    }

    @Override
    public <I extends Serializable, O extends Serializable> O require(STaskDef<I, O> sTaskDef, I input) {
        return this.require(sTaskDef.toTaskDef(this.taskDefs), input);
    }

    @Override
    public <I extends Serializable, O extends Serializable> O require(STaskDef<I, O> sTaskDef, I input, OutputStamper stamper) {
        return this.require(sTaskDef.toTaskDef(this.taskDefs), input);
    }

    @Override
    public <O extends Serializable> O require(STask<O> sTask) {
        return sTask.get(this);
    }

    @Override
    public <O extends Serializable> O require(STask<O> sTask, OutputStamper stamper) {
        return sTask.get(this);
    }

    @Override
    public <O extends Serializable> O require(Supplier<O> supplier) {
        return supplier.get(this);
    }

    @Override
    public <I extends Serializable, O extends Serializable> O require(Function<I, O> function, I input) {
        return function.apply(this, input);
    }

    @Override
    public OutputStamper getDefaultOutputStamper() {
        return OutputStampers.equals();
    }

    @Override
    public ResourceService getResourceService() {
        return this.resourceService;
    }

    @Override
    public <R extends Resource> boolean require(R resource, ResourceStamper<R> stamper) throws IOException {
        return true;
    }

    @Override
    public <R extends Resource> boolean provide(R resource, ResourceStamper<R> stamper) throws IOException {
        return true;
    }

    @Override
    public ResourceStamper<ReadableResource> getDefaultRequireReadableResourceStamper() {
        return ResourceStampers.modifiedFile();
    }

    @Override
    public ResourceStamper<ReadableResource> getDefaultProvideReadableResourceStamper() {
        return ResourceStampers.modifiedFile();
    }

    @Override
    public ResourceStamper<HierarchicalResource> getDefaultRequireHierarchicalResourceStamper() {
        return ResourceStampers.modifiedFile();
    }

    @Override
    public ResourceStamper<HierarchicalResource> getDefaultProvideHierarchicalResourceStamper() {
        return ResourceStampers.modifiedFile();
    }

    @Override
    public @Nullable Serializable getInternalObject() {
        return this.internalObject;
    }

    @Override
    public void setInternalObject(@Nullable Serializable obj) {
        this.internalObject = obj;
    }

    @Override
    public void clearInternalObject() {
        this.internalObject = null;
    }

    @Override
    public @Nullable Serializable getPreviousInput() {
        return null;
    }

    @Override
    public @Nullable Serializable getPreviousOutput() {
        return null;
    }

    @Override
    public @Nullable Observability getPreviousObservability() {
        return null;
    }

    @Override
    public Iterable<TaskRequireDep> getPreviousTaskRequireDeps() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<ResourceRequireDep> getPreviousResourceRequireDeps() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<ResourceProvideDep> getPreviousResourceProvideDeps() {
        return Collections.emptySet();
    }

    @Override
    public CancelToken cancelToken() {
        return NullCancelableToken.instance;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }
}

