/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.ud;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.IReplacement;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple3;

public class Diseq
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static ILogger logger = LoggerUtils.logger(Diseq.class);
    private final Set.Immutable<ITermVar> universals;
    private final IUnifier.Immutable diseqs;
    private final Set.Immutable<ITermVar> domainSetCache;
    private final Set.Immutable<ITermVar> freeVarSetCache;

    private Diseq(Set.Immutable<ITermVar> universals, IUnifier.Immutable diseqs) {
        this.universals = CapsuleUtil.toSet(universals);
        this.diseqs = diseqs;
        this.domainSetCache = this.diseqs.domainSet().__removeAll(this.universals);
        this.freeVarSetCache = this.diseqs.varSet().__removeAll(this.universals);
    }

    private Diseq(Set.Immutable<ITermVar> universals, IUnifier.Immutable diseqs, Set.Immutable<ITermVar> domainSetCache, Set.Immutable<ITermVar> freeVarSetCache) {
        this.universals = CapsuleUtil.toSet(universals);
        this.diseqs = diseqs;
        this.domainSetCache = domainSetCache;
        this.freeVarSetCache = freeVarSetCache;
    }

    public Set.Immutable<ITermVar> universals() {
        return this.universals;
    }

    public IUnifier.Immutable disequalities() {
        return this.diseqs;
    }

    public Set.Immutable<ITermVar> freeVarSet() {
        return this.freeVarSetCache;
    }

    public boolean isEmpty() {
        return this.diseqs.isEmpty();
    }

    public Set.Immutable<ITermVar> domainSet() {
        return this.domainSetCache;
    }

    public Tuple3<io.usethesource.capsule.Set<ITermVar>, ITerm, ITerm> toTuple() {
        ImmutableList.Builder lefts = ImmutableList.builder();
        ImmutableList.Builder rights = ImmutableList.builder();
        for (ITermVar var : this.diseqs.domainSet()) {
            lefts.add((Object)var);
            rights.add((Object)this.diseqs.findTerm(var));
        }
        return Tuple3.of(this.universals, TermBuild.B.newTuple((Iterable<? extends ITerm>)lefts.build()), TermBuild.B.newTuple((Iterable<? extends ITerm>)rights.build()));
    }

    public Optional<Diseq> apply(ISubstitution.Immutable subst) {
        Diseq diseq;
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.universals);
        if (this.universals.isEmpty()) {
            diseq = this;
        } else {
            FreshVars fv = new FreshVars(new Set[]{this.freeVarSet(), localSubst.rangeSet()});
            diseq = this.rename(fv.fresh((Set<ITermVar>)this.universals));
        }
        IUnifier.Transient newDiseqs = PersistentUnifier.Immutable.of(diseq.diseqs.isFinite()).melt();
        for (ITermVar var : diseq.diseqs.domainSet()) {
            try {
                if (newDiseqs.unify(localSubst.apply(var), localSubst.apply(diseq.diseqs.findTerm(var))).isPresent()) continue;
                return Optional.empty();
            }
            catch (OccursException e) {
                return Optional.empty();
            }
        }
        Set.Immutable newUniversals = Set.Immutable.intersect(diseq.universals, newDiseqs.varSet());
        return Optional.of(new Diseq((Set.Immutable<ITermVar>)newUniversals, newDiseqs.freeze()));
    }

    public Diseq removeAll(Iterable<ITermVar> _vars) {
        Set.Immutable vars = CapsuleUtil.toSet(_vars);
        if (!this.universals.isEmpty()) {
            vars = vars.__removeAll(this.universals);
        }
        IUnifier.Immutable newDiseqs = this.diseqs.removeAll((Iterable<ITermVar>)vars).unifier();
        return new Diseq(this.universals, newDiseqs);
    }

    public Diseq rename(IRenaming renaming) {
        if (renaming.isEmpty()) {
            return this;
        }
        Set.Immutable universals = (Set.Immutable)this.universals.stream().map(renaming::rename).collect(CapsuleCollectors.toSet());
        IUnifier.Immutable diseqs = this.diseqs.rename(renaming);
        return new Diseq((Set.Immutable<ITermVar>)universals, diseqs);
    }

    public Diseq replace(IReplacement replacement) {
        if (replacement.isEmpty()) {
            return this;
        }
        return new Diseq(this.universals, this.diseqs.replace(replacement), this.domainSetCache, this.freeVarSetCache);
    }

    public boolean implies(Diseq other) {
        IUnifier.Result ur;
        Diseq diseq;
        block5: {
            Diseq otherDiseq;
            if (this.universals.isEmpty() && other.universals.isEmpty()) {
                diseq = this;
                otherDiseq = other;
            } else {
                Set.Immutable freeVars = Set.Immutable.union(this.freeVarSet(), other.freeVarSet());
                FreshVars fv = new FreshVars((Iterable<ITermVar>)freeVars);
                diseq = this.rename(fv.fresh((Set<ITermVar>)this.universals));
                otherDiseq = other.rename(fv.fresh((Set<ITermVar>)other.universals));
            }
            Set.Immutable universals = Set.Immutable.union(diseq.universals, otherDiseq.universals);
            Predicate1<ITermVar> isRigid = v -> !universals.contains(v);
            ur = otherDiseq.diseqs.unify(diseq.diseqs, isRigid).orElse(null);
            if (ur != null) break block5;
            return false;
        }
        try {
            IUnifier.Result<ISubstitution.Immutable> rr = ((IUnifier.Immutable)ur.result()).removeAll((Iterable<ITermVar>)diseq.universals);
            return rr.unifier().isEmpty();
        }
        catch (OccursException | RigidException e) {
            return false;
        }
    }

    public String toString() {
        return this.toTuple().apply((T1 us, T2 v, T3 t) -> {
            if (us.isEmpty()) {
                return v + " != " + t;
            }
            return "forall " + us + " . " + v + " != " + t;
        });
    }

    public static Diseq of(Iterable<ITermVar> _universals, IUnifier.Immutable diseqs) {
        Set.Immutable<ITermVar> universals = CapsuleUtil.toSet(_universals);
        IUnifier.Immutable newDiseqs = diseqs.removeAll((Iterable<ITermVar>)universals).unifier();
        Set.Immutable newUniversals = Set.Immutable.intersect(universals, newDiseqs.varSet());
        return new Diseq((Set.Immutable<ITermVar>)newUniversals, newDiseqs);
    }

    public static Optional<Diseq> of(Iterable<ITermVar> universals, ITerm left, ITerm right) {
        try {
            IUnifier.Result ur = PersistentUnifier.Immutable.of().unify(left, right).orElse(null);
            if (ur != null) {
                return Optional.of(Diseq.of(universals, ur.unifier()));
            }
            return Optional.empty();
        }
        catch (OccursException e) {
            return Optional.empty();
        }
    }
}

