/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.stratego;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import org.metaborg.util.Ref;

public class ConstraintTerms {
    private static final String LIST_CTOR = "CList";
    private static final String LISTTAIL_CTOR = "CListTail";
    private static final String VAR_CTOR = "CVar";

    private ConstraintTerms() {
    }

    public static ITerm specialize(ITerm term) {
        ITerm newTerm = term.match(Terms.cases(appl -> {
            List<ITerm> args = appl.getArgs();
            ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)args.size());
            for (ITerm arg : args) {
                newArgs.add((Object)ConstraintTerms.specialize(arg));
            }
            return TermBuild.B.newAppl(appl.getOp(), (Iterable<? extends ITerm>)newArgs.build(), term.getAttachments());
        }, list -> ConstraintTerms.specializeList(list), string -> string, integer -> integer, blob -> blob, var -> {
            throw new IllegalArgumentException("Term is already specialized.");
        })).withAttachments(term.getAttachments());
        newTerm = TermMatch.M.preserveAttachments(TermMatch.M.cases(TermMatch.M.appl2(VAR_CTOR, TermMatch.M.stringValue(), TermMatch.M.stringValue(), (v, resource, name) -> TermBuild.B.newVar((String)resource, (String)name)), TermMatch.M.appl1(LIST_CTOR, TermMatch.M.list(), (t, xs) -> xs), TermMatch.M.appl2(LISTTAIL_CTOR, TermMatch.M.listElems(), TermMatch.M.term(), (t, xs, ys) -> TermBuild.B.newListTail((Iterable<? extends ITerm>)xs, (IListTerm)ys)))).match(newTerm).orElse(newTerm);
        return newTerm;
    }

    private static IListTerm specializeList(IListTerm list) {
        ArrayList terms = Lists.newArrayListWithExpectedSize((int)list.getMinSize());
        ArrayList attachments = Lists.newArrayListWithCapacity((int)list.getMinSize());
        Ref varTail = new Ref();
        while (list != null) {
            list = list.match(ListTerms.cases(cons -> {
                terms.add(ConstraintTerms.specialize(cons.getHead()));
                attachments.add(cons.getAttachments());
                return cons.getTail();
            }, nil -> {
                attachments.add(nil.getAttachments());
                return null;
            }, var -> {
                varTail.set(var);
                return null;
            }));
        }
        if (varTail.get() != null) {
            return TermBuild.B.newListTail(terms, (IListTerm)varTail.get(), attachments);
        }
        return TermBuild.B.newList(terms, attachments);
    }

    public static <R> TermMatch.IMatcher<R> specialize(TermMatch.IMatcher<R> m) {
        return (term, unifier) -> m.match(ConstraintTerms.specialize(term), unifier);
    }

    public static ITerm explicate(ITerm term) {
        return term.match(Terms.cases(appl -> {
            List<ITerm> args = appl.getArgs();
            ImmutableList.Builder newArgs = ImmutableList.builderWithExpectedSize((int)args.size());
            for (ITerm arg : args) {
                newArgs.add((Object)ConstraintTerms.explicate(arg));
            }
            return TermBuild.B.newAppl(appl.getOp(), (Iterable<? extends ITerm>)newArgs.build(), term.getAttachments());
        }, list -> ConstraintTerms.explicate(list), string -> string, integer -> integer, blob -> blob, var -> ConstraintTerms.explicate(var))).withAttachments(term.getAttachments());
    }

    private static ITerm explicate(IListTerm list) {
        ArrayList terms = Lists.newArrayListWithExpectedSize((int)list.getMinSize());
        ArrayList attachments = Lists.newArrayListWithExpectedSize((int)list.getMinSize());
        Ref varTail = new Ref();
        while (list != null) {
            list = list.match(ListTerms.cases(cons -> {
                terms.add(ConstraintTerms.explicate(cons.getHead()));
                attachments.add(cons.getAttachments());
                return cons.getTail();
            }, nil -> {
                attachments.add(nil.getAttachments());
                return null;
            }, var -> {
                varTail.set(ConstraintTerms.explicate(var));
                attachments.add(Attachments.empty());
                return null;
            }));
        }
        list = TermBuild.B.newList(terms, attachments);
        if (varTail.get() != null) {
            return TermBuild.B.newAppl(LISTTAIL_CTOR, (Iterable<? extends ITerm>)ImmutableList.of((Object)list, (Object)((ITerm)varTail.get())));
        }
        return list;
    }

    private static ITerm explicate(ITermVar var) {
        return TermBuild.B.newAppl(VAR_CTOR, Arrays.asList(TermBuild.B.newString(var.getResource()), TermBuild.B.newString(var.getName())));
    }

    public static <R> TermMatch.IMatcher<R> explicate(TermMatch.IMatcher<R> m) {
        return (t, u) -> m.match(ConstraintTerms.explicate(t), u);
    }
}

