/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.IResult;
import mb.nabl2.spoofax.primitives.NaBL2Primitive;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;
import org.spoofax.interpreter.core.InterpreterException;

public abstract class AnalysisPrimitive
extends NaBL2Primitive {
    protected final int tvars;

    public AnalysisPrimitive(String name) {
        this(name, 0);
    }

    public AnalysisPrimitive(String name, int tvars) {
        super(name, tvars + 1);
        this.tvars = tvars;
    }

    @Override
    protected Optional<? extends ITerm> call(ITerm term, List<ITerm> terms) throws InterpreterException {
        if (terms.size() < 1) {
            throw new IllegalArgumentException("Expected as first term argument: analysis");
        }
        ITerm analysisTerm = terms.get(0);
        List<ITerm> otherTerms = terms.stream().skip(1L).collect(Collectors.toList());
        IResult result = TermMatch.M.blobValue(IResult.class).match(analysisTerm).orElseThrow(() -> new IllegalArgumentException("Not a valid analysis term: " + analysisTerm));
        return this.call(result, term, otherTerms);
    }

    protected Optional<? extends ITerm> call(IResult result, ITerm term, List<ITerm> terms) throws InterpreterException {
        return this.call(result.solution(), term, terms);
    }

    protected Optional<? extends ITerm> call(ISolution solution, ITerm term, List<ITerm> terms) throws InterpreterException {
        return Optional.empty();
    }
}

