/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.solvers.BaseSolver;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;

public final class GraphSolution
extends BaseSolver.AGraphSolution
implements Serializable {
    private final SolverConfig config;
    private final IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties;
    private final IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph;
    private final IUnifier.Immutable unifier;
    private final IMessages.Immutable messages;
    private final ImmutableSet<IConstraint> constraints;
    private static final long serialVersionUID = 42L;

    private GraphSolution(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IUnifier.Immutable unifier, IMessages.Immutable messages, Iterable<? extends IConstraint> constraints) {
        this.config = Objects.requireNonNull(config, "config");
        this.astProperties = Objects.requireNonNull(astProperties, "astProperties");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.unifier = Objects.requireNonNull(unifier, "unifier");
        this.messages = Objects.requireNonNull(messages, "messages");
        this.constraints = ImmutableSet.copyOf(constraints);
    }

    private GraphSolution(GraphSolution original, SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IUnifier.Immutable unifier, IMessages.Immutable messages, ImmutableSet<IConstraint> constraints) {
        this.config = config;
        this.astProperties = astProperties;
        this.scopeGraph = scopeGraph;
        this.unifier = unifier;
        this.messages = messages;
        this.constraints = constraints;
    }

    @Override
    public SolverConfig config() {
        return this.config;
    }

    @Override
    public IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties() {
        return this.astProperties;
    }

    @Override
    public IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public IUnifier.Immutable unifier() {
        return this.unifier;
    }

    @Override
    public IMessages.Immutable messages() {
        return this.messages;
    }

    @Override
    public ImmutableSet<IConstraint> constraints() {
        return this.constraints;
    }

    public final GraphSolution withConfig(SolverConfig value) {
        if (this.config == value) {
            return this;
        }
        SolverConfig newValue = Objects.requireNonNull(value, "config");
        return new GraphSolution(this, newValue, this.astProperties, this.scopeGraph, this.unifier, this.messages, this.constraints);
    }

    public final GraphSolution withAstProperties(IProperties.Immutable<TermIndex, ITerm, ITerm> value) {
        if (this.astProperties == value) {
            return this;
        }
        IProperties.Immutable<TermIndex, ITerm, ITerm> newValue = Objects.requireNonNull(value, "astProperties");
        return new GraphSolution(this, this.config, newValue, this.scopeGraph, this.unifier, this.messages, this.constraints);
    }

    public final GraphSolution withScopeGraph(IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new GraphSolution(this, this.config, this.astProperties, newValue, this.unifier, this.messages, this.constraints);
    }

    public final GraphSolution withUnifier(IUnifier.Immutable value) {
        if (this.unifier == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "unifier");
        return new GraphSolution(this, this.config, this.astProperties, this.scopeGraph, newValue, this.messages, this.constraints);
    }

    public final GraphSolution withMessages(IMessages.Immutable value) {
        if (this.messages == value) {
            return this;
        }
        IMessages.Immutable newValue = Objects.requireNonNull(value, "messages");
        return new GraphSolution(this, this.config, this.astProperties, this.scopeGraph, this.unifier, newValue, this.constraints);
    }

    public final GraphSolution withConstraints(IConstraint ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new GraphSolution(this, this.config, this.astProperties, this.scopeGraph, this.unifier, this.messages, (ImmutableSet<IConstraint>)newValue);
    }

    public final GraphSolution withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new GraphSolution(this, this.config, this.astProperties, this.scopeGraph, this.unifier, this.messages, (ImmutableSet<IConstraint>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GraphSolution && this.equalTo((GraphSolution)another);
    }

    private boolean equalTo(GraphSolution another) {
        return this.config.equals(another.config) && this.astProperties.equals(another.astProperties) && this.scopeGraph.equals(another.scopeGraph) && this.unifier.equals(another.unifier) && this.messages.equals(another.messages) && this.constraints.equals(another.constraints);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.astProperties.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + this.unifier.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GraphSolution").omitNullValues().add("config", (Object)this.config).add("astProperties", this.astProperties).add("scopeGraph", this.scopeGraph).add("unifier", (Object)this.unifier).add("messages", (Object)this.messages).add("constraints", this.constraints).toString();
    }

    public static GraphSolution of(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IUnifier.Immutable unifier, IMessages.Immutable messages, ImmutableSet<IConstraint> constraints) {
        return GraphSolution.of(config, astProperties, scopeGraph, unifier, messages, constraints);
    }

    public static GraphSolution of(SolverConfig config, IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties, IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph, IUnifier.Immutable unifier, IMessages.Immutable messages, Iterable<? extends IConstraint> constraints) {
        return new GraphSolution(config, astProperties, scopeGraph, unifier, messages, constraints);
    }

    public static GraphSolution copyOf(BaseSolver.AGraphSolution instance) {
        if (instance instanceof GraphSolution) {
            return (GraphSolution)instance;
        }
        return GraphSolution.of(instance.config(), instance.astProperties(), instance.scopeGraph(), instance.unifier(), instance.messages(), instance.constraints());
    }
}

