/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.ast.CAstProperty;
import mb.nabl2.constraints.ast.IAstConstraint;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.util.collections.IProperties;

public class AstComponent
extends ASolver {
    private final IProperties.Transient<TermIndex, ITerm, ITerm> properties;

    public AstComponent(SolverCore core, IProperties.Transient<TermIndex, ITerm, ITerm> initial) {
        super(core);
        this.properties = initial;
    }

    public SeedResult seed(IProperties.Immutable<TermIndex, ITerm, ITerm> solution, IMessageInfo message) throws InterruptedException {
        solution.stream().forEach(entry -> this.putProperty((TermIndex)entry._1(), (ITerm)entry._2(), (ITerm)entry._3(), message));
        return SeedResult.empty();
    }

    public SolveResult solve(IAstConstraint constraint) {
        return constraint.match(IAstConstraint.Cases.of(astp -> this.solve((CAstProperty)astp)));
    }

    private SolveResult solve(CAstProperty astp) {
        return this.putProperty(astp.getIndex(), astp.getKey(), astp.getValue(), astp.getMessageInfo()).map(cc -> SolveResult.constraints(cc)).orElseGet(() -> SolveResult.empty());
    }

    private Optional<IConstraint> putProperty(TermIndex index, ITerm key, ITerm value, IMessageInfo message) {
        Optional prev = this.properties.getValue(index, key);
        if (!prev.isPresent()) {
            this.properties.putValue(index, key, value);
            return Optional.empty();
        }
        return Optional.of(CEqual.of(value, (ITerm)prev.get(), message));
    }

    public IProperties.Immutable<TermIndex, ITerm, ITerm> finish() {
        return this.properties.freeze();
    }
}

