/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.sets;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sets.ACSubsetEq;
import mb.nabl2.terms.ITerm;

public final class CSubsetEq
extends ACSubsetEq
implements Serializable {
    private final ITerm left;
    private final ITerm right;
    private final String projection;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CSubsetEq(ITerm left, ITerm right, Optional<String> projection, IMessageInfo messageInfo) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.projection = projection.orElse(null);
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CSubsetEq(CSubsetEq original, ITerm left, ITerm right, String projection, IMessageInfo messageInfo) {
        this.left = left;
        this.right = right;
        this.projection = projection;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getLeft() {
        return this.left;
    }

    @Override
    public ITerm getRight() {
        return this.right;
    }

    @Override
    public Optional<String> getProjection() {
        return Optional.ofNullable(this.projection);
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CSubsetEq withLeft(ITerm value) {
        if (this.left == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "left");
        return new CSubsetEq(this, newValue, this.right, this.projection, this.messageInfo);
    }

    public final CSubsetEq withRight(ITerm value) {
        if (this.right == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "right");
        return new CSubsetEq(this, this.left, newValue, this.projection, this.messageInfo);
    }

    public final CSubsetEq withProjection(String value) {
        String newValue = Objects.requireNonNull(value, "projection");
        if (Objects.equals(this.projection, newValue)) {
            return this;
        }
        return new CSubsetEq(this, this.left, this.right, newValue, this.messageInfo);
    }

    public final CSubsetEq withProjection(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.projection, value)) {
            return this;
        }
        return new CSubsetEq(this, this.left, this.right, value, this.messageInfo);
    }

    public final CSubsetEq withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CSubsetEq(this, this.left, this.right, this.projection, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CSubsetEq && this.equalTo((CSubsetEq)another);
    }

    private boolean equalTo(CSubsetEq another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.right.equals(another.right) && Objects.equals(this.projection, another.projection) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + Objects.hashCode(this.projection);
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CSubsetEq of(ITerm left, ITerm right, Optional<String> projection, IMessageInfo messageInfo) {
        return new CSubsetEq(left, right, projection, messageInfo);
    }

    public static CSubsetEq copyOf(ACSubsetEq instance) {
        if (instance instanceof CSubsetEq) {
            return (CSubsetEq)instance;
        }
        return CSubsetEq.of(instance.getLeft(), instance.getRight(), instance.getProjection(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CSubsetEq(this, this.left, this.right, this.projection, this.messageInfo);
    }
}

