/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import com.google.common.collect.ImmutableList;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.MessageContent;

final class CompoundMessage
extends MessageContent.ACompoundMessage
implements Serializable {
    private final ImmutableList<IMessageContent> parts;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CompoundMessage(Iterable<? extends IMessageContent> parts) {
        this.parts = ImmutableList.copyOf(parts);
        this.hashCode = this.computeHashCode();
    }

    private CompoundMessage(CompoundMessage original, ImmutableList<IMessageContent> parts) {
        this.parts = parts;
        this.hashCode = this.computeHashCode();
    }

    ImmutableList<IMessageContent> getParts() {
        return this.parts;
    }

    public final CompoundMessage withParts(IMessageContent ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new CompoundMessage(this, (ImmutableList<IMessageContent>)newValue);
    }

    public final CompoundMessage withParts(Iterable<? extends IMessageContent> elements) {
        if (this.parts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new CompoundMessage(this, (ImmutableList<IMessageContent>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CompoundMessage && this.equalTo((CompoundMessage)another);
    }

    private boolean equalTo(CompoundMessage another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.parts.equals(another.parts);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.parts.hashCode();
        return h;
    }

    public static CompoundMessage of(List<IMessageContent> parts) {
        return CompoundMessage.of(parts);
    }

    public static CompoundMessage of(Iterable<? extends IMessageContent> parts) {
        return new CompoundMessage(parts);
    }

    public static CompoundMessage copyOf(MessageContent.ACompoundMessage instance) {
        if (instance instanceof CompoundMessage) {
            return (CompoundMessage)instance;
        }
        return CompoundMessage.of(instance.getParts());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CompoundMessage(this, this.parts);
    }
}

